/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master.index;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class AgentXIndexRegistry {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXIndexRegistry.class);
    private final Map<IndexRegistryEntry, IndexRegistryEntry> indexes = Collections.synchronizedMap(new HashMap());

    public int allocate(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        try {
            vb.getVariable().toSubIndex(true);
        }
        catch (UnsupportedOperationException ex) {
            return 258;
        }
        IndexRegistryEntry newEntry = new IndexRegistryEntry(context, vb);
        IndexRegistryEntry oldEntry = this.indexes.get(newEntry);
        if (oldEntry == null) {
            if (!testOnly) {
                int status = newEntry.allocate(sessionID, vb.getVariable(), testOnly);
                if (status == 0) {
                    this.indexes.put(newEntry, newEntry);
                }
                return status;
            }
            return 0;
        }
        return oldEntry.allocate(sessionID, vb.getVariable(), testOnly);
    }

    public int release(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        IndexRegistryEntry newEntry = new IndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        if (entry == null) {
            return 261;
        }
        if (entry.getIndexType().getSyntax() != vb.getSyntax()) {
            return 261;
        }
        return entry.release(sessionID, vb.getVariable(), testOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int sessionID) {
        Map<IndexRegistryEntry, IndexRegistryEntry> map = this.indexes;
        synchronized (map) {
            for (IndexRegistryEntry entry : this.indexes.values()) {
                entry.release(sessionID);
            }
        }
    }

    public int newIndex(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        Variable v;
        IndexRegistryEntry newEntry = new IndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        if (entry == null) {
            entry = new IndexRegistryEntry(context, vb);
        }
        if ((v = entry.newIndex(sessionID, testOnly)) == null) {
            return 260;
        }
        if (!testOnly) {
            vb.setVariable(v);
        }
        return 0;
    }

    public int anyIndex(int sessionID, OctetString context, VariableBinding vb, boolean testOnly) {
        Variable v;
        IndexRegistryEntry newEntry = new IndexRegistryEntry(context, vb);
        IndexRegistryEntry entry = this.indexes.get(newEntry);
        boolean newEntryCreated = false;
        if (entry == null) {
            entry = new IndexRegistryEntry(context, vb);
            newEntryCreated = true;
        }
        if ((v = entry.anyIndex(sessionID, testOnly)) == null) {
            return 260;
        }
        if (!testOnly) {
            vb.setVariable(v);
            if (newEntryCreated) {
                this.indexes.put(entry, entry);
            }
        }
        return 0;
    }

    class IndexRegistryEntry
    implements Comparable {
        private OctetString context;
        private VariableBinding indexType;
        private SortedMap<IndexEntry, IndexEntry> indexValues = new TreeMap<IndexEntry, IndexEntry>(new IndexComparator());
        private SortedMap<IndexEntry, IndexEntry> usedValues = new TreeMap<IndexEntry, IndexEntry>(new IndexComparator());

        public IndexRegistryEntry(OctetString context, VariableBinding indexType) {
            this.context = context == null ? new OctetString() : context;
            this.indexType = indexType;
        }

        public synchronized int allocate(int sessionID, Variable indexValue, boolean testOnly) {
            IndexEntry newEntry = new IndexEntry(sessionID, indexValue);
            if (indexValue.getSyntax() != this.indexType.getSyntax()) {
                return 258;
            }
            if (this.indexValues.get(newEntry) != null) {
                return 259;
            }
            if (!testOnly) {
                this.indexValues.put(newEntry, newEntry);
            }
            return 0;
        }

        public synchronized int release(int sessionID, Variable indexValue, boolean testOnly) {
            IndexEntry removeKey = new IndexEntry(sessionID, indexValue);
            IndexEntry contained = (IndexEntry)this.indexValues.get(removeKey);
            if (contained != null && contained.getSessionID() == sessionID) {
                if (!testOnly) {
                    IndexEntry r = (IndexEntry)this.indexValues.remove(contained);
                    this.usedValues.put(r, r);
                }
                return 0;
            }
            return 261;
        }

        public synchronized void release(int sessionID) {
            Iterator<IndexEntry> it = this.indexValues.values().iterator();
            while (it.hasNext()) {
                IndexEntry entry = it.next();
                if (entry.getSessionID() != sessionID) continue;
                it.remove();
                this.usedValues.put(entry, entry);
            }
        }

        public int compareTo(Object o) {
            IndexRegistryEntry other = (IndexRegistryEntry)o;
            int c = this.context.compareTo((Variable)other.context);
            if (c == 0) {
                c = this.indexType.getOid().compareTo((Variable)other.indexType.getOid());
            }
            return c;
        }

        public int hashCode() {
            return this.indexType.getOid().hashCode() + (this.context == null ? 0 : this.context.hashCode());
        }

        public boolean equals(Object o) {
            if (o instanceof IndexRegistryEntry) {
                return this.indexType.getOid().equals((Object)((IndexRegistryEntry)o).indexType.getOid());
            }
            return false;
        }

        public VariableBinding getIndexType() {
            return this.indexType;
        }

        public OctetString getContext() {
            return this.context;
        }

        public synchronized Variable newIndex(int sessionID, boolean testOnly) {
            try {
                IndexEntry last = null;
                if (!this.usedValues.isEmpty()) {
                    last = this.usedValues.lastKey();
                }
                if (!this.indexValues.isEmpty()) {
                    IndexEntry lastAllocated = this.indexValues.lastKey();
                    if (last == null) {
                        last = lastAllocated;
                    } else if (lastAllocated.compareTo(last) > 0) {
                        last = lastAllocated;
                    }
                } else if (last == null) {
                    return this.anyIndex(sessionID, testOnly);
                }
                OID nextIndex = last.getIndexValue().toSubIndex(true);
                nextIndex = nextIndex.nextPeer();
                Variable nextIndexValue = (Variable)last.getIndexValue().clone();
                nextIndexValue.fromSubIndex(nextIndex, true);
                int status = this.allocate(sessionID, nextIndexValue, testOnly);
                if (status != 0) {
                    return null;
                }
                return nextIndexValue;
            }
            catch (Exception ex) {
                LOGGER.error((CharSequence)("Exception occurred while creating/allocating new index:" + ex.getMessage()), (Throwable)ex);
                return null;
            }
        }

        public synchronized Variable anyIndex(int sessionID, boolean testOnly) {
            try {
                OID nextIndex;
                if (this.usedValues.isEmpty()) {
                    nextIndex = this.indexValues.isEmpty() ? this.indexType.getVariable().toSubIndex(true) : this.indexValues.lastKey().getIndexValue().toSubIndex(true);
                } else {
                    IndexEntry last = this.usedValues.firstKey();
                    nextIndex = last.getIndexValue().toSubIndex(true);
                }
                nextIndex = nextIndex.nextPeer();
                Variable nextIndexValue = (Variable)this.indexType.getVariable().clone();
                nextIndexValue.fromSubIndex(nextIndex, true);
                int status = this.allocate(sessionID, nextIndexValue, testOnly);
                if (status != 0) {
                    return null;
                }
                return nextIndexValue;
            }
            catch (Exception ex) {
                LOGGER.error((CharSequence)("Exception occurred while creating/allocating any new index:" + ex.getMessage()), (Throwable)ex);
                return null;
            }
        }

        private class IndexComparator
        implements Comparator<IndexEntry> {
            private IndexComparator() {
            }

            @Override
            public int compare(IndexEntry o1, IndexEntry o2) {
                Variable c1 = o1.getIndexValue();
                Variable c2 = o2.getIndexValue();
                return c1.compareTo(c2);
            }
        }
    }

    class IndexEntry
    implements Comparable {
        private int sessionID;
        private Variable indexValue;

        public IndexEntry(int sessionID, Variable indexValue) {
            this.sessionID = sessionID;
            this.indexValue = indexValue;
        }

        public int getSessionID() {
            return this.sessionID;
        }

        public Variable getIndexValue() {
            return this.indexValue;
        }

        public int hashCode() {
            return this.indexValue.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof IndexEntry) {
                return this.indexValue.equals(((IndexEntry)o).indexValue) && this.sessionID == ((IndexEntry)o).sessionID;
            }
            if (o instanceof Variable) {
                return this.indexValue.equals(o);
            }
            return false;
        }

        public int compareTo(Object o) {
            OID indexOID = this.indexValue.toSubIndex(true);
            if (o instanceof IndexEntry) {
                return indexOID.compareTo((Variable)((IndexEntry)o).indexValue.toSubIndex(true));
            }
            if (o instanceof Variable) {
                return indexOID.compareTo((Variable)((Variable)o).toSubIndex(true));
            }
            throw new ClassCastException(o.getClass() + " != (IndexEntry or Variable)");
        }
    }
}

