/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXNodeQuery.java  
  _## 
  _##  Copyright (C) 2005-2009  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.master;

import org.snmp4j.agent.*;
import org.snmp4j.smi.OctetString;

public class AgentXNodeQuery implements MOQuery {

  public static final int QUERY_AGENTX_NODES = 1;
  public static final int QUERY_NON_AGENTX_NODES = 0;
  public static final int QUERY_ALL = 2;

  private DefaultMOContextScope scope;
  private int queryMode;

  public AgentXNodeQuery(OctetString context, MOScope scope, int queryMode) {
    this.scope = new DefaultMOContextScope(context, scope);
    this.queryMode = queryMode;
  }

  public MOContextScope getScope() {
    return scope;
  }

  public DefaultMOContextScope getMutableScope() {
    return scope;
  }

  public boolean matchesQuery(ManagedObject managedObject) {
    if (managedObject instanceof AgentXNode) {
      return queryMode > QUERY_NON_AGENTX_NODES;
    }
    return queryMode != QUERY_AGENTX_NODES;
  }

  public void substractScope(MOScope scope) {
    this.scope.substractScope(scope);
  }

  public boolean isWriteAccessQuery() {
    return false;
  }
}
