/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentppTestMib.java  
  _## 
  _##  Copyright (C) 2005-2009  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.subagent.test;

//--AgentGen BEGIN=_BEGIN
//--AgentGen END

import org.snmp4j.smi.*;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.agent.*;
import org.snmp4j.agent.mo.*;
import org.snmp4j.agent.mo.snmp.*;
import org.snmp4j.agent.mo.snmp.smi.*;
import org.snmp4j.agent.request.*;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.agent.agentx.subagent.DefaultAgentXSharedMOTable;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTableSupport;
import java.util.GregorianCalendar;

//--AgentGen BEGIN=_IMPORT
//--AgentGen END

public class AgentppTestMib
//--AgentGen BEGIN=_EXTENDS
//--AgentGen END
implements MOGroup
//--AgentGen BEGIN=_IMPLEMENTS
//--AgentGen END
{

  private static final LogAdapter LOGGER =
      LogFactory.getLogger(AgentppTestMib.class);

//--AgentGen BEGIN=_STATIC
//--AgentGen END

  // Factory
  private MOFactory moFactory =
    DefaultMOFactory.getInstance();

  // Constants
  public static final OID oidAgentppTestTimeout =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,1,0 });

  // Scalars
  private MOScalar agentppTestTimeout;

  // Tables
  public static final OID oidAgentppTestSharedEntry =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,3,1 });

  // Index OID definitions
  public static final OID oidAgentppTestSharedTableIndex =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,3,1,1 });

  // Column TC defintions for agentppTestSharedEntry:
  public static final String tcModuleSNMPv2Tc = "SNMPv2-TC";
  public static final String tcDefDateAndTime = "DateAndTime";
  public static final String tcDefRowStatus = "RowStatus";

  // Column sub-identifer defintions for agentppTestSharedEntry:
  public static final int colAgentppTestSharedTableCreationTime = 2;
  public static final int colAgentppTestSharedTableDelay = 3;
  public static final int colAgentppTestSharedTableSession = 4;
  public static final int colAgentppTestSharedTableRowStatus = 5;

  // Column index defintions for agentppTestSharedEntry:
  public static final int idxAgentppTestSharedTableCreationTime = 0;
  public static final int idxAgentppTestSharedTableDelay = 1;
  public static final int idxAgentppTestSharedTableSession = 2;
  public static final int idxAgentppTestSharedTableRowStatus = 3;

  private MOTableSubIndex[] agentppTestSharedEntryIndexes;
  private MOTableIndex agentppTestSharedEntryIndex;

  private MOTable      agentppTestSharedEntry;
  private MOTableModel agentppTestSharedEntryModel;
  public static final OID oidAgentppTestSessionsEntry =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,4,1 });

  // Index OID definitions
  public static final OID oidAgentppTestSessionIndex =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,4,1,1 });

  // Column TC defintions for agentppTestSessionsEntry:

  // Column sub-identifer defintions for agentppTestSessionsEntry:
  public static final int colAgentppTestRowCreation = 2;

  // Column index defintions for agentppTestSessionsEntry:
  public static final int idxAgentppTestRowCreation = 0;

  private MOTableSubIndex[] agentppTestSessionsEntryIndexes;
  private MOTableIndex agentppTestSessionsEntryIndex;

  private MOTable      agentppTestSessionsEntry;
  private MOTableModel agentppTestSessionsEntryModel;
  public static final OID oidAgentppTestSparseEntry =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,5,1 });

  // Index OID definitions
  public static final OID oidAgentppTestSparseIndex =
    new OID(new int[] { 1,3,6,1,4,1,4976,6,3,1,5,1,1 });

  // Column TC defintions for agentppTestSparseEntry:

  // Column sub-identifer defintions for agentppTestSparseEntry:
  public static final int colAgentppTestSparseCol1 = 2;
  public static final int colAgentppTestSparseCol2 = 3;
  public static final int colAgentppTestSparseCol3 = 4;
  public static final int colAgentppTestSparseRowStatus = 5;

  // Column index defintions for agentppTestSparseEntry:
  public static final int idxAgentppTestSparseCol1 = 0;
  public static final int idxAgentppTestSparseCol2 = 1;
  public static final int idxAgentppTestSparseCol3 = 2;
  public static final int idxAgentppTestSparseRowStatus = 3;

  private MOTableSubIndex[] agentppTestSparseEntryIndexes;
  private MOTableIndex agentppTestSparseEntryIndex;

  private MOTable      agentppTestSparseEntry;
  private MOTableModel agentppTestSparseEntryModel;


//--AgentGen BEGIN=_MEMBERS
//--AgentGen END

  /**
   * Constructs a AgentppTestMib instance without actually creating its
   * <code>ManagedObject</code> instances. This has to be done in a
   * sub-class constructor or after construction by calling
   * {@link #createMO(MOFactory moFactory)}.
   */
  protected AgentppTestMib() {
//--AgentGen BEGIN=_DEFAULTCONSTRUCTOR
//--AgentGen END
  }

  /**
   * Constructs a AgentppTestMib instance and actually creates its
   * <code>ManagedObject</code> instances using the supplied
   * <code>MOFactory</code> (by calling
   * {@link #createMO(MOFactory moFactory)}).
   * @param moFactory
   *    the <code>MOFactory</code> to be used to create the
   *    managed objects for this module.
   */
  public AgentppTestMib(MOFactory moFactory) {
    createMO(moFactory);
//--AgentGen BEGIN=_FACTORYCONSTRUCTOR
//--AgentGen END
  }

//--AgentGen BEGIN=_CONSTRUCTORS
//--AgentGen END

  /**
   * Create the ManagedObjects defined for this MIB module
   * using the specified {@link MOFactory}.
   * @param moFactory
   *    the <code>MOFactory</code> instance to use for object
   *    creation.
   */
  protected void createMO(MOFactory moFactory) {
    agentppTestTimeout =
      new AgentppTestTimeout(oidAgentppTestTimeout,
                             moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_WRITE));
    agentppTestTimeout.addMOValueValidationListener(new AgentppTestTimeoutValidator());
    createAgentppTestSharedEntry(moFactory);
    createAgentppTestSessionsEntry(moFactory);
    createAgentppTestSparseEntry(moFactory);
  }


  public MOTable getAgentppTestSharedEntry() {
    return agentppTestSharedEntry;
  }


  private void createAgentppTestSharedEntry(MOFactory moFactory) {
    // Index definition
    agentppTestSharedEntryIndexes =
      new MOTableSubIndex[] {
      moFactory.createSubIndex(oidAgentppTestSharedTableIndex,
                               SMIConstants.SYNTAX_INTEGER, 1, 1)    };

    agentppTestSharedEntryIndex =
      moFactory.createIndex(agentppTestSharedEntryIndexes,
                            false,
                            new MOTableIndexValidator() {
      public boolean isValidIndex(OID index) {
        boolean isValidIndex = true;
     //--AgentGen BEGIN=agentppTestSharedEntry::isValidIndex
     //--AgentGen END
        return isValidIndex;
      }
    });

    // Columns
    MOColumn[] agentppTestSharedEntryColumns = new MOColumn[4];
    agentppTestSharedEntryColumns[idxAgentppTestSharedTableCreationTime] =
      moFactory.createColumn(colAgentppTestSharedTableCreationTime,
                             SMIConstants.SYNTAX_OCTET_STRING,
                             moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_ONLY),
                             tcModuleSNMPv2Tc,
                             tcDefDateAndTime);
    agentppTestSharedEntryColumns[idxAgentppTestSharedTableDelay] =
      moFactory.createColumn(colAgentppTestSharedTableDelay,
                          SMIConstants.SYNTAX_INTEGER32,
                          moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             new Integer32(0),
                             true);
    ValueConstraint agentppTestSharedTableDelayVC = new ConstraintsImpl();
    ((ConstraintsImpl)agentppTestSharedTableDelayVC).add(new Constraint(0L, 6000L));
    ((MOMutableColumn)agentppTestSharedEntryColumns[idxAgentppTestSharedTableDelay]).
      addMOValueValidationListener(new ValueConstraintValidator(agentppTestSharedTableDelayVC));
    ((MOMutableColumn)agentppTestSharedEntryColumns[idxAgentppTestSharedTableDelay]).
      addMOValueValidationListener(new AgentppTestSharedTableDelayValidator());
    agentppTestSharedEntryColumns[idxAgentppTestSharedTableSession] =
      moFactory.createColumn(colAgentppTestSharedTableSession,
                             SMIConstants.SYNTAX_GAUGE32,
                             moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_ONLY));
    agentppTestSharedEntryColumns[idxAgentppTestSharedTableRowStatus] =
      moFactory.createColumn(colAgentppTestSharedTableRowStatus,
                             SMIConstants.SYNTAX_INTEGER,
                             moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             tcModuleSNMPv2Tc,
                             tcDefRowStatus);
    ((MOMutableColumn)agentppTestSharedEntryColumns[idxAgentppTestSharedTableRowStatus]).
      addMOValueValidationListener(new AgentppTestSharedTableRowStatusValidator());
    // Table model
    agentppTestSharedEntryModel =
      moFactory.createTableModel(oidAgentppTestSharedEntry,
                                 agentppTestSharedEntryIndex,
                                 agentppTestSharedEntryColumns);
    ((MOMutableTableModel)agentppTestSharedEntryModel).setRowFactory(
      new AgentppTestSharedEntryRowFactory());
    agentppTestSharedEntry =
      moFactory.createTable(oidAgentppTestSharedEntry,
                            agentppTestSharedEntryIndex,
                            agentppTestSharedEntryColumns,
                            agentppTestSharedEntryModel);
  }

  public MOTable getAgentppTestSessionsEntry() {
    return agentppTestSessionsEntry;
  }


  private void createAgentppTestSessionsEntry(MOFactory moFactory) {
    // Index definition
    agentppTestSessionsEntryIndexes =
      new MOTableSubIndex[] {
      moFactory.createSubIndex(oidAgentppTestSessionIndex,
                               SMIConstants.SYNTAX_INTEGER, 1, 1)    };

    agentppTestSessionsEntryIndex =
      moFactory.createIndex(agentppTestSessionsEntryIndexes,
                            false,
                            new MOTableIndexValidator() {
      public boolean isValidIndex(OID index) {
        boolean isValidIndex = true;
     //--AgentGen BEGIN=agentppTestSessionsEntry::isValidIndex
     //--AgentGen END
        return isValidIndex;
      }
    });

    // Columns
    MOColumn[] agentppTestSessionsEntryColumns = new MOColumn[1];
    agentppTestSessionsEntryColumns[idxAgentppTestRowCreation] =
      moFactory.createColumn(colAgentppTestRowCreation,
                             SMIConstants.SYNTAX_GAUGE32,
                             moFactory.createAccess(
                                 MOAccessImpl.ACCESSIBLE_FOR_READ_WRITE),
                             new UnsignedInteger32(0),
                             true);
    ((MOMutableColumn)agentppTestSessionsEntryColumns[idxAgentppTestRowCreation]).
      addMOValueValidationListener(new AgentppTestRowCreationValidator());
    // Table model
    agentppTestSessionsEntryModel =
      moFactory.createTableModel(oidAgentppTestSessionsEntry,
                                 agentppTestSessionsEntryIndex,
                                 agentppTestSessionsEntryColumns);
    ((MOMutableTableModel)agentppTestSessionsEntryModel).setRowFactory(
      new AgentppTestSessionsEntryRowFactory());
    agentppTestSessionsEntry =
      moFactory.createTable(oidAgentppTestSessionsEntry,
                            agentppTestSessionsEntryIndex,
                            agentppTestSessionsEntryColumns,
                            agentppTestSessionsEntryModel);
  }

  public MOTable getAgentppTestSparseEntry() {
    return agentppTestSparseEntry;
  }


  private void createAgentppTestSparseEntry(MOFactory moFactory) {
    // Index definition
    agentppTestSparseEntryIndexes =
      new MOTableSubIndex[] {
      moFactory.createSubIndex(oidAgentppTestSparseIndex,
                               SMIConstants.SYNTAX_OCTET_STRING, 0, 255)
    };

    agentppTestSparseEntryIndex =
      moFactory.createIndex(agentppTestSparseEntryIndexes,
                            false,
                            null);

    // Columns
    MOColumn[] agentppTestSparseEntryColumns = new MOColumn[4];
    agentppTestSparseEntryColumns[idxAgentppTestSparseCol1] =
      moFactory.createColumn(colAgentppTestSparseCol1,
                             SMIConstants.SYNTAX_INTEGER32,
                             moFactory.createAccess(
                                 MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             new Integer32(1),
                             true);
    ((MOMutableColumn)agentppTestSparseEntryColumns[idxAgentppTestSparseCol1]).
      addMOValueValidationListener(new AgentppTestSparseCol1Validator());
    agentppTestSparseEntryColumns[idxAgentppTestSparseCol2] =
      moFactory.createColumn(colAgentppTestSparseCol2,
                             SMIConstants.SYNTAX_GAUGE32,
                             moFactory.createAccess(
                                 MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             new Gauge32(2),
                             true);
    ((MOMutableColumn)agentppTestSparseEntryColumns[idxAgentppTestSparseCol2]).
      addMOValueValidationListener(new AgentppTestSparseCol2Validator());
    agentppTestSparseEntryColumns[idxAgentppTestSparseCol3] =
      moFactory.createColumn(colAgentppTestSparseCol3,
                          SMIConstants.SYNTAX_OCTET_STRING,
                          moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             new OctetString(new byte[] { (byte)51 }),
                             true);
    ValueConstraint agentppTestSparseCol3VC = new ConstraintsImpl();
    ((ConstraintsImpl)agentppTestSparseCol3VC).add(new Constraint(0L, 255L));
    ((MOMutableColumn)agentppTestSparseEntryColumns[idxAgentppTestSparseCol3]).
      addMOValueValidationListener(new ValueConstraintValidator(agentppTestSparseCol3VC));
    ((MOMutableColumn)agentppTestSparseEntryColumns[idxAgentppTestSparseCol3]).
      addMOValueValidationListener(new AgentppTestSparseCol3Validator());
    agentppTestSparseEntryColumns[idxAgentppTestSparseRowStatus] =
      moFactory.createColumn(colAgentppTestSparseRowStatus,
                             SMIConstants.SYNTAX_INTEGER,
                             moFactory.createAccess(MOAccessImpl.ACCESSIBLE_FOR_READ_CREATE),
                             tcModuleSNMPv2Tc,
                             tcDefRowStatus);
    ((MOMutableColumn)agentppTestSparseEntryColumns[idxAgentppTestSparseRowStatus]).
      addMOValueValidationListener(new AgentppTestSparseRowStatusValidator());
    // Table model
    agentppTestSparseEntryModel =
      moFactory.createTableModel(oidAgentppTestSparseEntry,
                                 agentppTestSparseEntryIndex,
                                 agentppTestSparseEntryColumns);
    ((MOMutableTableModel)agentppTestSparseEntryModel).setRowFactory(
      new AgentppTestSparseEntryRowFactory());
    agentppTestSparseEntry =
      moFactory.createTable(oidAgentppTestSparseEntry,
                            agentppTestSparseEntryIndex,
                            agentppTestSparseEntryColumns,
                            agentppTestSparseEntryModel);
  }



  public void registerMOs(MOServer server, OctetString context)
    throws DuplicateRegistrationException
  {
    // Scalar Objects
    server.register(this.agentppTestTimeout, context);
    server.register(this.agentppTestSharedEntry, context);
    server.register(this.agentppTestSessionsEntry, context);
    server.register(this.agentppTestSparseEntry, context);
//--AgentGen BEGIN=_registerMOs
    for (int i=0; i<10; i++) {
      Variable[] vbs = agentppTestSparseEntry.getDefaultValues();
      vbs[idxAgentppTestSparseRowStatus] = new Integer32(RowStatus.active);
      MOTableRow row =
          agentppTestSparseEntry.createRow(new OID(
          new int[] { 1, 48+i }), vbs);
      agentppTestSparseEntry.addRow(row);
    }
//--AgentGen END
  }

  public void unregisterMOs(MOServer server, OctetString context) {
    // Scalar Objects
    server.unregister(this.agentppTestTimeout, context);
    server.unregister(this.agentppTestSharedEntry, context);
    server.unregister(this.agentppTestSessionsEntry, context);
    server.unregister(this.agentppTestSparseEntry, context);
//--AgentGen BEGIN=_unregisterMOs
//--AgentGen END
  }

  // Notifications

  // Scalars
  public class AgentppTestTimeout extends MOScalar {
    AgentppTestTimeout(OID oid, MOAccess access) {
      super(oid, access, new UnsignedInteger32());
//--AgentGen BEGIN=agentppTestTimeout
//--AgentGen END
    }

    public int isValueOK(SubRequest request) {
      Variable newValue =
        request.getVariableBinding().getVariable();
      int valueOK = super.isValueOK(request);
      if (valueOK != SnmpConstants.SNMP_ERROR_SUCCESS) {
      	return valueOK;
      }
      long v = ((UnsignedInteger32)newValue).getValue();
      if (!(((v >= 0L) && (v <= 1000000L)))) {
        valueOK = SnmpConstants.SNMP_ERROR_WRONG_VALUE;
      }
     //--AgentGen BEGIN=agentppTestTimeout::isValueOK
     //--AgentGen END
      return valueOK;
    }

    public Variable getValue() {
     //--AgentGen BEGIN=agentppTestTimeout::getValue
     //--AgentGen END
      return super.getValue();
    }

    public int setValue(Variable newValue) {
     //--AgentGen BEGIN=agentppTestTimeout::setValue
     //--AgentGen END
      return super.setValue(newValue);
    }

     //--AgentGen BEGIN=agentppTestTimeout::_METHODS
     //--AgentGen END

  }


  // Value Validators
  /**
   * The <code>AgentppTestTimeoutValidator</code> implements the value
   * validation for <code>AgentppTestTimeout</code>.
   */
  static class AgentppTestTimeoutValidator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
      long v = ((UnsignedInteger32)newValue).getValue();
      if (!(((v >= 0L) && (v <= 1000000L)))) {
        validationEvent.setValidationStatus(SnmpConstants.SNMP_ERROR_WRONG_VALUE);
        return;
      }
     //--AgentGen BEGIN=agentppTestTimeout::validate
     //--AgentGen END
    }
  }

  /**
   * The <code>AgentppTestSharedTableDelayValidator</code> implements the value
   * validation for <code>AgentppTestSharedTableDelay</code>.
   */
  static class AgentppTestSharedTableDelayValidator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
      long v = ((Integer32)newValue).getValue();
      if (!(((v >= 0L) && (v <= 6000L)))) {
        validationEvent.setValidationStatus(SnmpConstants.SNMP_ERROR_WRONG_VALUE);
        return;
      }
     //--AgentGen BEGIN=agentppTestSharedTableDelay::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestSharedTableRowStatusValidator</code> implements the value
   * validation for <code>AgentppTestSharedTableRowStatus</code>.
   */
  static class AgentppTestSharedTableRowStatusValidator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
     //--AgentGen BEGIN=agentppTestSharedTableRowStatus::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestRowCreationValidator</code> implements the value
   * validation for <code>AgentppTestRowCreation</code>.
   */
  static class AgentppTestRowCreationValidator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
     //--AgentGen BEGIN=agentppTestRowCreation::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestSparseCol1Validator</code> implements the value
   * validation for <code>AgentppTestSparseCol1</code>.
   */
  static class AgentppTestSparseCol1Validator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
     //--AgentGen BEGIN=agentppTestSparseCol1::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestSparseCol2Validator</code> implements the value
   * validation for <code>AgentppTestSparseCol2</code>.
   */
  static class AgentppTestSparseCol2Validator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
     //--AgentGen BEGIN=agentppTestSparseCol2::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestSparseCol3Validator</code> implements the value
   * validation for <code>AgentppTestSparseCol3</code>.
   */
  static class AgentppTestSparseCol3Validator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
      OctetString os = (OctetString)newValue;
      if (!(((os.length() >= 0) && (os.length() <= 255)))) {
        validationEvent.setValidationStatus(SnmpConstants.SNMP_ERROR_WRONG_LENGTH);
        return;
      }
     //--AgentGen BEGIN=agentppTestSparseCol3::validate
     //--AgentGen END
    }
  }
  /**
   * The <code>AgentppTestSparseRowStatusValidator</code> implements the value
   * validation for <code>AgentppTestSparseRowStatus</code>.
   */
  static class AgentppTestSparseRowStatusValidator implements MOValueValidationListener {

    public void validate(MOValueValidationEvent validationEvent) {
      Variable newValue = validationEvent.getNewValue();
     //--AgentGen BEGIN=agentppTestSparseRowStatus::validate
     //--AgentGen END
    }
  }

  // Rows and Factories
  public class AgentppTestSharedEntryRow extends DefaultMOMutableRow2PC {
    public AgentppTestSharedEntryRow(OID index, Variable[] values) {
      super(index, values);
    }

    public OctetString getAgentppTestSharedTableCreationTime() {
      return (OctetString) getValue(idxAgentppTestSharedTableCreationTime);
    }

    public void setAgentppTestSharedTableCreationTime(OctetString newValue) {
      setValue(idxAgentppTestSharedTableCreationTime, newValue);
    }

    public Integer32 getAgentppTestSharedTableDelay() {
      return (Integer32) getValue(idxAgentppTestSharedTableDelay);
    }

    public void setAgentppTestSharedTableDelay(Integer32 newValue) {
      setValue(idxAgentppTestSharedTableDelay, newValue);
    }

    public UnsignedInteger32 getAgentppTestSharedTableSession() {
      return (UnsignedInteger32) getValue(idxAgentppTestSharedTableSession);
    }

    public void setAgentppTestSharedTableSession(UnsignedInteger32 newValue) {
      setValue(idxAgentppTestSharedTableSession, newValue);
    }

    public Integer32 getAgentppTestSharedTableRowStatus() {
      return (Integer32) getValue(idxAgentppTestSharedTableRowStatus);
    }

    public void setAgentppTestSharedTableRowStatus(Integer32 newValue) {
      setValue(idxAgentppTestSharedTableRowStatus, newValue);
    }

    //--AgentGen BEGIN=agentppTestSharedEntry::Row

    private void delayRequest() {
      long delay = values[idxAgentppTestSharedTableDelay].toInt() * 10;
      if (delay > 0) {
        try {
          Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
        }
      }
    }

    public Variable getValue(int column) {
      delayRequest();
      return super.getValue(column);
    }

    public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
      delayRequest();
      super.commit(subRequest, changeSet, column);
    }

     //--AgentGen END
  }

  class AgentppTestSharedEntryRowFactory
        extends DefaultMOMutableRow2PCFactory
  {
    public synchronized MOTableRow createRow(OID index, Variable[] values)
        throws UnsupportedOperationException
    {
      AgentppTestSharedEntryRow row = new AgentppTestSharedEntryRow(index, values);
     //--AgentGen BEGIN=agentppTestSharedEntry::createRow
     //--AgentGen END
      return row;
    }

    public synchronized void freeRow(MOTableRow row) {
     //--AgentGen BEGIN=agentppTestSharedEntry::freeRow
     //--AgentGen END
    }

     //--AgentGen BEGIN=agentppTestSharedEntry::RowFactory
     //--AgentGen END
  }
  public class AgentppTestSessionsEntryRow extends DefaultMOMutableRow2PC {
    public AgentppTestSessionsEntryRow(OID index, Variable[] values) {
      super(index, values);
    }

    public UnsignedInteger32 getAgentppTestRowCreation() {
      return (UnsignedInteger32) getValue(idxAgentppTestRowCreation);
    }

    public void setAgentppTestRowCreation(UnsignedInteger32 newValue) {
      setValue(idxAgentppTestRowCreation, newValue);
    }

    //--AgentGen BEGIN=agentppTestSessionsEntry::Row
    public void commitRow(SubRequest subRequest, MOTableRow changeSet) {
      int newRowIndex =
          changeSet.getValue(idxAgentppTestRowCreation).toInt();
      if (newRowIndex != 0) {
        OID newIndex = new OID(new int[] { newRowIndex});
        Variable[] values = agentppTestSharedEntry.getDefaultValues();
        values[idxAgentppTestSharedTableRowStatus] =
            new Integer32(RowStatus.active);
        values[idxAgentppTestSharedTableCreationTime] =
            DateAndTime.makeDateAndTime(new GregorianCalendar());
        values[idxAgentppTestSharedTableSession] =
            new UnsignedInteger32(getIndex().get(0));
        MOTableRow row = agentppTestSharedEntry.createRow(newIndex, values);
        if (row != null) {
          if (!agentppTestSharedEntry.addRow(row)) {
            ((UnsignedInteger32) changeSet.getValue(idxAgentppTestRowCreation)).
                setValue(0);
          }
        }
        else {
          ((UnsignedInteger32) changeSet.getValue(idxAgentppTestRowCreation)).
              setValue(0);
        }
      }
    }
    //--AgentGen END
  }

  class AgentppTestSessionsEntryRowFactory
        extends DefaultMOMutableRow2PCFactory
  {
    public synchronized MOTableRow createRow(OID index, Variable[] values)
        throws UnsupportedOperationException
    {
      AgentppTestSessionsEntryRow row = new AgentppTestSessionsEntryRow(index, values);
     //--AgentGen BEGIN=agentppTestSessionsEntry::createRow
     //--AgentGen END
      return row;
    }

    public synchronized void freeRow(MOTableRow row) {
     //--AgentGen BEGIN=agentppTestSessionsEntry::freeRow
     //--AgentGen END
    }

     //--AgentGen BEGIN=agentppTestSessionsEntry::RowFactory
     //--AgentGen END
  }
  public class AgentppTestSparseEntryRow extends DefaultMOMutableRow2PC {
    public AgentppTestSparseEntryRow(OID index, Variable[] values) {
      super(index, values);
    }

    public Integer32 getAgentppTestSparseCol1() {
      return (Integer32) getValue(idxAgentppTestSparseCol1);
    }

    public void setAgentppTestSparseCol1(Integer32 newValue) {
      setValue(idxAgentppTestSparseCol1, newValue);
    }

    public Gauge32 getAgentppTestSparseCol2() {
      return (Gauge32) getValue(idxAgentppTestSparseCol2);
    }

    public void setAgentppTestSparseCol2(Gauge32 newValue) {
      setValue(idxAgentppTestSparseCol2, newValue);
    }

    public OctetString getAgentppTestSparseCol3() {
      return (OctetString) getValue(idxAgentppTestSparseCol3);
    }

    public void setAgentppTestSparseCol3(OctetString newValue) {
      setValue(idxAgentppTestSparseCol3, newValue);
    }

    public Integer32 getAgentppTestSparseRowStatus() {
      return (Integer32) getValue(idxAgentppTestSparseRowStatus);
    }

    public void setAgentppTestSparseRowStatus(Integer32 newValue) {
      setValue(idxAgentppTestSparseRowStatus, newValue);
    }

    //--AgentGen BEGIN=agentppTestSparseEntry::Row

    public void setValue(int column, Variable value) {
      if (column != idxAgentppTestSparseRowStatus) {
        if (value.equals(getValue(column))) {
          super.setValue(column, null);
          return;
        }
      }
      super.setValue(column, value);
    }

     //--AgentGen END
  }

  class AgentppTestSparseEntryRowFactory
        extends DefaultMOMutableRow2PCFactory
  {
    public synchronized MOTableRow createRow(OID index, Variable[] values)
        throws UnsupportedOperationException
    {
      AgentppTestSparseEntryRow row = new AgentppTestSparseEntryRow(index, values);
     //--AgentGen BEGIN=agentppTestSparseEntry::createRow
     //--AgentGen END
      return row;
    }

    public synchronized void freeRow(MOTableRow row) {
     //--AgentGen BEGIN=agentppTestSparseEntry::freeRow
     //--AgentGen END
    }

     //--AgentGen BEGIN=agentppTestSparseEntry::RowFactory
     //--AgentGen END
  }


//--AgentGen BEGIN=_METHODS
  public static MOFactory getSharedTableFactory() {
    return new AgentppTestMOFactory();
  }
//--AgentGen END

//--AgentGen BEGIN=_CLASSES
  static class AgentppTestMOFactory extends DefaultMOFactory {
    public MOTable createTable(OID oid, MOTableIndex indexDef,
                               MOColumn[] columns) {
      if (oidAgentppTestSessionsEntry.equals(oid)) {
        return new DefaultAgentXSharedMOTable(oid, indexDef, columns) {
          public void setAgentXSharedMOTableSupport(AgentXSharedMOTableSupport
              sharedTableSupport) {
            super.setAgentXSharedMOTableSupport(sharedTableSupport);
            ((MOMutableTableModel)model).clear();
            OID index =
                new OID(new int[] { sharedTableSupport.getSession().getSessionID() });
            MOTableRow row = createRow(index);
            if (row != null) {
              addRow(row);
            }
          }
        };
      }
      return new DefaultAgentXSharedMOTable(oid, indexDef, columns);
    }

    public MOTable createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns,
                               MOTableModel model) {
      DefaultAgentXSharedMOTable table =
          (DefaultAgentXSharedMOTable) createTable(oid, indexDef, columns);
      table.setModel(model);
      return table;
    }

  }
//--AgentGen END

//--AgentGen BEGIN=_END
//--AgentGen END
}


