/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class AgentXOpenPDU
extends AgentXPDU {
    protected byte timeout;
    protected OID subagentID;
    protected OctetString subagentDescr;

    AgentXOpenPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != 1) {
            throw new IllegalArgumentException("Incompatible PDU type");
        }
    }

    public AgentXOpenPDU(int sessionID, int transactionID, int packetID, byte timeout, OID subagentID, OctetString subagentDescr) {
        super((byte)1, (byte)0, sessionID, transactionID, packetID);
        this.timeout = timeout;
        this.subagentID = subagentID;
        this.subagentDescr = subagentDescr;
    }

    public void decodePayload(ByteBuffer buf, int length) throws IOException {
        this.timeout = buf.get();
        buf.get();
        buf.get();
        buf.get();
        this.subagentID = new OID();
        AgentXProtocol.decodeOID(buf, this.subagentID);
        this.subagentDescr = AgentXProtocol.decodeOctetString(buf);
    }

    public OctetString getSubagentDescr() {
        return this.subagentDescr;
    }

    public OID getSubagentID() {
        return this.subagentID;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setSubagentDescr(OctetString subagentDescr) {
        this.subagentDescr = subagentDescr;
    }

    public void setSubagentID(OID subagentID) {
        this.subagentID = subagentID;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public int getPayloadLength() {
        return 4 + AgentXProtocol.getOIDLength(this.subagentID) + AgentXProtocol.getOctetStringLength(this.subagentDescr.length());
    }

    public void encodePayload(ByteBuffer buf) {
        buf.put(this.timeout);
        buf.put(new byte[]{0, 0, 0});
        AgentXProtocol.encodeOID(buf, this.subagentID, false);
        AgentXProtocol.encodeOctetString(buf, this.subagentDescr);
    }

    protected void beforeEncode() {
    }
}

