/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXParseException;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public class AgentXMessageDispatcherImpl
implements AgentXMessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger((Class)AgentXMessageDispatcherImpl.class);
    private List transportMappings = new ArrayList();
    private List commandListener = new ArrayList();
    private volatile int nextPacketID = 0;

    public synchronized int getNextPacketID() {
        int nextID;
        if ((nextID = ++this.nextPacketID) <= 0) {
            this.nextPacketID = 1;
            nextID = 1;
        }
        return nextID;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextPacketID());
    }

    public synchronized void addTransportMapping(TransportMapping transport) {
        this.transportMappings.add(transport);
        transport.addTransportListener((TransportListener)this);
    }

    public Collection getTransportMappings() {
        return new ArrayList(this.transportMappings);
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage) {
        block3: {
            try {
                AgentXPDU pdu = AgentXPDU.decode(wholeMessage);
                AgentXCommandEvent event = new AgentXCommandEvent((Object)this, (AgentXMessageDispatcher)this, incomingAddress, sourceTransport, pdu);
                this.fireCommandEvent(event);
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                logger.warn((Object)ex);
                if (!(ex instanceof AgentXParseException)) break block3;
                AgentXCommandEvent event = new AgentXCommandEvent((Object)this, (AgentXMessageDispatcher)this, incomingAddress, sourceTransport, (AgentXParseException)ex);
                this.fireCommandEvent(event);
            }
        }
    }

    public TransportMapping removeTransportMapping(TransportMapping transport) {
        if (this.transportMappings.remove(transport)) {
            transport.removeTransportListener((TransportListener)this);
            return transport;
        }
        return null;
    }

    public PduHandle send(TransportMapping transport, Address address, AgentXPDU message, PduHandleCallback callback) throws IOException {
        PduHandle handle;
        if (message instanceof AgentXResponsePDU) {
            handle = new PduHandle(message.getPacketID());
        } else {
            handle = this.createPduHandle();
            message.setPacketID(handle.getTransactionID());
        }
        if (callback != null) {
            callback.pduHandleAssigned(handle, (Object)message);
        }
        if (transport != null) {
            this.sendPDU(address, message, transport);
            return handle;
        }
        for (int i = 0; i < this.transportMappings.size(); ++i) {
            TransportMapping t = (TransportMapping)this.transportMappings.get(i);
            if (!address.getClass().equals(t.getSupportedAddressClass())) continue;
            this.sendPDU(address, message, t);
            return handle;
        }
        return null;
    }

    private void sendPDU(Address address, AgentXPDU message, TransportMapping transport) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(message.getPayloadLength() + 20);
        message.encode(buf);
        this.send(address, transport, buf);
    }

    public void send(Address address, TransportMapping transport, ByteBuffer message) throws IOException {
        message.flip();
        byte[] bytes = new byte[message.limit()];
        message.get(bytes);
        transport.sendMessage(address, bytes);
    }

    protected synchronized void fireCommandEvent(AgentXCommandEvent event) {
        for (int i = 0; i < this.commandListener.size(); ++i) {
            ((AgentXCommandListener)this.commandListener.get(i)).processCommand(event);
            if (!event.isProcessed()) continue;
            return;
        }
    }

    public synchronized void addCommandListener(AgentXCommandListener l) {
        this.commandListener.add(l);
    }

    public synchronized void removeCommandListener(AgentXCommandListener l) {
        this.commandListener.remove(l);
    }
}

