/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponseListener;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXTarget;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.transport.TransportListener;

public class AgentX
implements AgentXCommandListener {
    private static final LogAdapter logger = LogFactory.getLogger((Class)AgentX.class);
    private AgentXMessageDispatcher messageDispatcher;
    private Map pendingRequests = Collections.synchronizedMap(new HashMap(50));
    private Map asyncRequests = Collections.synchronizedMap(new HashMap(50));
    private Timer timer = new Timer(true);
    private Vector commandListeners;

    public AgentX(AgentXMessageDispatcher dispatcher) {
        this.messageDispatcher = dispatcher;
        this.messageDispatcher.addCommandListener(this);
    }

    public void addTransportMapping(TransportMapping transport) {
        this.messageDispatcher.addTransportMapping(transport);
        transport.addTransportListener((TransportListener)this.messageDispatcher);
    }

    public void removeTransportMapping(TransportMapping transport) {
        this.messageDispatcher.removeTransportMapping(transport);
        transport.removeTransportListener((TransportListener)this.messageDispatcher);
    }

    public synchronized void removeCommandResponder(AgentXCommandListener listener) {
        if (this.commandListeners != null && this.commandListeners.contains(listener)) {
            Vector v = (Vector)this.commandListeners.clone();
            v.removeElement(listener);
            this.commandListeners = v;
        }
    }

    public synchronized void addCommandResponder(AgentXCommandListener listener) {
        Vector v;
        Vector vector = v = this.commandListeners == null ? new Vector(2) : (Vector)this.commandListeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.commandListeners = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentXResponseEvent send(AgentXPDU pdu, AgentXTarget target, TransportMapping transport) throws IOException {
        SyncResponseListener syncResponse = new SyncResponseListener();
        if (!pdu.isConfirmedPDU()) {
            this.sendMessage(pdu, target, transport, null);
            return null;
        }
        SyncResponseListener syncResponseListener = syncResponse;
        synchronized (syncResponseListener) {
            PendingRequest request = new PendingRequest(null, syncResponse, target, pdu, target);
            this.sendMessage(pdu, target, transport, request);
            try {
                while (syncResponse.response == null) {
                    syncResponse.wait();
                }
            }
            catch (InterruptedException iex) {
                logger.warn((Object)iex);
            }
        }
        return syncResponse.response;
    }

    public void send(AgentXPDU pdu, AgentXTarget target, TransportMapping transport, Object userHandle, AgentXResponseListener listener) throws IOException {
        PendingRequest request = new PendingRequest(null, listener, userHandle, pdu, target);
        this.sendMessage(pdu, target, transport, request);
    }

    protected PduHandle sendMessage(AgentXPDU pdu, AgentXTarget target, TransportMapping transport, PduHandleCallback pduHandleCallback) throws IOException {
        PduHandle handle = this.messageDispatcher.send(transport, target.getAddress(), pdu, pduHandleCallback);
        return handle;
    }

    public void processCommand(AgentXCommandEvent event) {
        AgentXPDU pdu = event.getCommand();
        PduHandle handle = new PduHandle(pdu.getPacketID());
        if (pdu.getType() == 18) {
            PendingRequest request;
            event.setProcessed(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing pending request with handle " + handle));
            }
            if ((request = (PendingRequest)this.pendingRequests.remove(handle)) == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Received response that cannot be matched to any outstanding request, address=" + event.getPeerAddress() + ", packetID=" + pdu.getPacketID()));
                }
            } else {
                request.finished = true;
                request.listener.onResponse(new AgentXResponseEvent(this, request.target, event.getPeerAddress(), request.pdu, (AgentXResponsePDU)pdu, request.userObject));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fire process PDU event: " + event.toString()));
            }
            this.fireProcessPdu(event);
        }
    }

    protected void fireProcessPdu(AgentXCommandEvent event) {
        if (this.commandListeners != null) {
            Vector listeners = this.commandListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AgentXCommandListener)listeners.get(i)).processCommand(event);
                if (!event.isProcessed()) continue;
                return;
            }
        }
    }

    public AgentXMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    class SyncResponseListener
    implements AgentXResponseListener {
        private AgentXResponseEvent response = null;

        SyncResponseListener() {
        }

        public synchronized void onResponse(AgentXResponseEvent event) {
            this.response = event;
            this.notify();
        }

        public AgentXResponseEvent getResponse() {
            return this.response;
        }
    }

    class AsyncPendingRequest
    extends PendingRequest {
        public AsyncPendingRequest(PduHandle key, AgentXResponseListener listener, Object userObject, AgentXPDU pdu, AgentXTarget target) {
            super(key, listener, userObject, pdu, target);
        }

        protected void registerRequest(PduHandle handle) {
            AgentX.this.asyncRequests.put(new AsyncRequestKey(this.pdu, this.listener), handle);
        }
    }

    class PendingRequest
    extends TimerTask
    implements PduHandleCallback {
        protected PduHandle key;
        protected AgentXResponseListener listener;
        protected Object userObject;
        protected AgentXPDU pdu;
        protected AgentXTarget target;
        private volatile boolean finished = false;

        public PendingRequest(PduHandle key, AgentXResponseListener listener, Object userObject, AgentXPDU pdu, AgentXTarget target) {
            this.key = key;
            this.userObject = userObject;
            this.listener = listener;
            this.pdu = pdu;
            this.target = target;
        }

        protected void registerRequest(PduHandle handle) {
        }

        public synchronized void run() {
            AgentX.this.pendingRequests.remove(this.key);
            if (!this.finished) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AgentX request timed out: " + this.key.getTransactionID()));
                }
                this.finished = true;
                this.listener.onResponse(new AgentXResponseEvent(AgentX.this, this.target, null, this.pdu, null, this.userObject));
            }
        }

        public synchronized boolean setFinished() {
            boolean currentState = this.finished;
            this.finished = true;
            return currentState;
        }

        public synchronized void pduHandleAssigned(PduHandle handle, Object pdu) {
            if (this.key == null) {
                this.key = handle;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New pending request " + pdu + " with handle " + handle));
                }
                this.registerRequest(handle);
                AgentX.this.pendingRequests.put(handle, this);
                long delay = this.target.getTimeout();
                if (delay < 1000L) {
                    delay = 5000L;
                }
                AgentX.this.timer.schedule((TimerTask)this, delay);
            }
        }
    }

    class AsyncRequestKey {
        private AgentXPDU request;
        private AgentXResponseListener listener;

        public AsyncRequestKey(AgentXPDU request, AgentXResponseListener listener) {
            this.request = request;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AsyncRequestKey) {
                AsyncRequestKey other = (AsyncRequestKey)obj;
                return this.request.equals(other.request) && this.listener.equals(other.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.request.hashCode();
        }
    }
}

