/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent;

import java.io.IOException;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXIndexAllocatePDU;
import org.snmp4j.agent.agentx.AgentXIndexDeallocatePDU;
import org.snmp4j.agent.agentx.AgentXRegisterPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXUnregisterPDU;
import org.snmp4j.agent.agentx.subagent.index.AnyNewIndexOID;
import org.snmp4j.agent.agentx.subagent.index.NewIndexOID;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class AgentXSharedMOTableSupport
implements MOTableRowListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger((Class)AgentXSharedMOTableSupport.class);
    public static final int INDEX_MODE_ALLOCATE = 0;
    public static final int INDEX_MODE_ANY_INDEX = 4;
    public static final int INDEX_MODE_NEW_INDEX = 2;
    private AgentX agentX;
    private AgentXSession session;
    private OctetString context;
    private byte priority = (byte)127;
    private byte indexMode = 0;

    public AgentXSharedMOTableSupport(AgentX agentX, AgentXSession session, OctetString context) {
        this.agentX = agentX;
        this.session = session;
        this.context = context;
    }

    public AgentXSharedMOTableSupport(AgentX agentX, AgentXSession session, OctetString context, byte priority, byte indexAllocationMode) {
        this(agentX, session, context);
        this.priority = priority;
        this.indexMode = indexAllocationMode;
    }

    public void rowChanged(MOTableRowEvent event) {
        if (this.indexMode == 0 && this.getSession().isClosed()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Row event " + event + " ignored, because session to master agent is closed: " + this.getSession()));
            }
            return;
        }
        switch (event.getType()) {
            case 1: {
                OID index2Allocate = event.getRow().getIndex();
                int status = this.allocateIndex(this.context, event.getTable().getIndexDef(), event.getRow().getIndex().size() == 0 ? this.indexMode : (byte)0, index2Allocate);
                if (status == 0) break;
                event.setVetoStatus(status);
                break;
            }
            case 2: {
                int status = this.registerRow(event.getTable(), event.getRow());
                if (status == 0) break;
                event.setVetoStatus(status);
                break;
            }
            case 3: {
                int status = this.unregisterRow(event.getTable(), event.getRow());
                if (status != 0 && status != 264) {
                    event.setVetoStatus(status);
                    break;
                }
                OID index2Deallocate = event.getRow().getIndex();
                status = this.deallocateIndex(this.context, event.getTable().getIndexDef(), index2Deallocate);
                break;
            }
            default: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("Ignored AgentX shared table event " + event));
            }
        }
    }

    public int allocateIndex(OctetString context, MOTableIndex indexDef, byte indexAllocationMode, OID allocatedIndex) {
        MOTableSubIndex subIndex;
        int i;
        Variable[] indexValues;
        VariableBinding[] vbs = new VariableBinding[indexDef.size()];
        if (allocatedIndex instanceof AnyNewIndexOID) {
            indexAllocationMode = (byte)4;
        } else if (allocatedIndex instanceof NewIndexOID) {
            indexAllocationMode = (byte)2;
        }
        if (indexAllocationMode == 0) {
            indexValues = indexDef.getIndexValues(allocatedIndex);
        } else {
            indexValues = new Variable[indexDef.size()];
            for (i = 0; i < indexDef.size(); ++i) {
                subIndex = indexDef.getIndex(i);
                indexValues[i] = AbstractVariable.createFromSyntax((int)subIndex.getSmiSyntax());
            }
        }
        for (i = 0; i < indexDef.size(); ++i) {
            subIndex = indexDef.getIndex(i);
            OID oid = subIndex.getOid();
            if (oid == null) {
                throw new IllegalArgumentException("Sub-index " + i + " has no OID");
            }
            vbs[i] = new VariableBinding();
            vbs[i].setOid(oid);
            vbs[i].setVariable(indexValues[i]);
        }
        AgentXIndexAllocatePDU pdu = new AgentXIndexAllocatePDU(context, vbs);
        if (indexAllocationMode != 0) {
            pdu.addFlag(indexAllocationMode);
        }
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent response = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (response.getResponse() != null) {
                AgentXResponsePDU resp = response.getResponse();
                if (resp.getErrorStatus() == 0) {
                    OID index = indexDef.getIndexOID(AgentXSharedMOTableSupport.getVariables(resp.getVariableBindings()));
                    allocatedIndex.setValue(index.getValue());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Allocated index " + allocatedIndex + " for context " + context + " and index definition " + indexDef));
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Index allocation failed for context " + context + " and index definition " + indexDef + " with value " + allocatedIndex));
                }
                return resp.getErrorStatus();
            }
            return -11;
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to allocate index " + indexDef + " at " + this.session), (Throwable)ex);
            return -5;
        }
    }

    public int deallocateIndex(OctetString context, MOTableIndex indexDef, OID allocatedIndex) {
        VariableBinding[] vbs = new VariableBinding[indexDef.size()];
        Variable[] indexValues = indexDef.getIndexValues(allocatedIndex);
        for (int i = 0; i < indexDef.size(); ++i) {
            vbs[i] = new VariableBinding();
            MOTableSubIndex subIndex = indexDef.getIndex(i);
            OID oid = subIndex.getOid();
            if (oid == null) {
                throw new IllegalArgumentException("Sub-index " + i + " has no OID");
            }
            vbs[i].setOid(oid);
            vbs[i].setVariable(indexValues[i]);
        }
        AgentXIndexDeallocatePDU pdu = new AgentXIndexDeallocatePDU(context, vbs);
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent response = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (response.getResponse() != null) {
                AgentXResponsePDU resp = response.getResponse();
                return resp.getErrorStatus();
            }
            return -11;
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to deallocate index " + indexDef + " at " + this.session), (Throwable)ex);
            return -5;
        }
    }

    public int registerRow(MOTable table, MOTableRow row2Register) {
        OID subtree = new OID(table.getOID());
        subtree.append(table.getColumn(0).getColumnID());
        subtree.append(row2Register.getIndex());
        AgentXRegisterPDU pdu = new AgentXRegisterPDU(this.context, subtree, this.priority, (byte)(table.getOID().size() + 1), table.getColumn(table.getColumnCount() - 1).getColumnID());
        if (table.getColumnCount() == 1) {
            pdu.addFlag((byte)1);
        }
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent resp = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (resp.getResponse() == null) {
                return -11;
            }
            if (resp.getResponse().getErrorStatus() != 0) {
                return resp.getResponse().getErrorStatus();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to send AgentXRegister pdu " + pdu + " to " + this.session + " because: " + ex.getMessage()), (Throwable)ex);
            return -5;
        }
        return 0;
    }

    public int unregisterRow(MOTable table, MOTableRow row2Unregister) {
        OID subtree = new OID(table.getOID());
        subtree.append(table.getColumn(0).getColumnID());
        subtree.append(row2Unregister.getIndex());
        AgentXUnregisterPDU pdu = new AgentXUnregisterPDU(this.context, subtree, this.priority, (byte)(table.getOID().size() + 1), table.getColumn(table.getColumnCount() - 1).getColumnID());
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent resp = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (resp.getResponse() == null) {
                return -11;
            }
            if (resp.getResponse().getErrorStatus() != 0) {
                return resp.getResponse().getErrorStatus();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to send AgentXRegister pdu " + pdu + " to " + this.session + " because: " + ex.getMessage()), (Throwable)ex);
            return -5;
        }
        return 0;
    }

    private static Variable[] getVariables(VariableBinding[] vbs) {
        Variable[] variables = new Variable[vbs.length];
        for (int i = 0; i < vbs.length; ++i) {
            variables[i] = vbs[i].getVariable();
        }
        return variables;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setSession(AgentXSession session) {
        this.session = session;
    }

    public void setIndexMode(byte indexMode) {
        this.indexMode = indexMode;
    }

    public void setContext(OctetString context) {
        this.context = context;
    }

    public byte getPriority() {
        return this.priority;
    }

    public AgentXSession getSession() {
        return this.session;
    }

    public byte getIndexMode() {
        return this.indexMode;
    }

    public OctetString getContext() {
        return this.context;
    }

    public AgentX getAgentX() {
        return this.agentX;
    }
}

