/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.agentx.AgentXGetBulkPDU;
import org.snmp4j.agent.agentx.AgentXGetNextPDU;
import org.snmp4j.agent.agentx.AgentXGetPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.master.AbstractAgentXPending;
import org.snmp4j.agent.agentx.master.AgentXMasterAgent;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.agentx.master.AgentXSearchRange;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;

public class AgentXPendingGet
extends AbstractAgentXPending {
    private static final LogAdapter logger = LogFactory.getLogger((Class)AgentXPendingGet.class);
    private AgentXPDU agentXRequestPDU;
    private List searchRanges = new LinkedList();
    private short nonRepeater = 0;

    public AgentXPendingGet(AgentXRegEntry registration, SnmpRequest request, AgentXSearchRange searchRange) {
        super(registration, request);
        this.searchRanges.add(searchRange);
    }

    public synchronized void addSearchRange(AgentXSearchRange searchRange) {
        this.searchRanges.add(searchRange);
    }

    public void setNonRepeater(short nonRepeater) {
        this.nonRepeater = nonRepeater;
    }

    public synchronized void incNonRepeater() {
        this.nonRepeater = (short)(this.nonRepeater + 1);
    }

    public AgentXPDU getAgentXPDU() {
        if (this.agentXRequestPDU == null) {
            this.createRequestPDU();
        }
        return this.agentXRequestPDU;
    }

    public Collection getSearchRanges() {
        return this.searchRanges;
    }

    public short getNonRepeater() {
        return this.nonRepeater;
    }

    private void createRequestPDU() {
        SnmpRequest request = (SnmpRequest)((AgentXSearchRange)((Object)this.searchRanges.get(0))).getReferenceSubRequest().getRequest();
        PDU requestPDU = request.getInitiatingEvent().getPDU();
        switch (requestPDU.getType()) {
            case -91: {
                short maxRep = AgentXPendingGet.getMaxRepetitions(request, requestPDU);
                this.agentXRequestPDU = new AgentXGetBulkPDU(request.getContext(), maxRep, this.nonRepeater, this.searchRanges.toArray(new MOScope[this.searchRanges.size()]));
                break;
            }
            case -96: {
                OID[] oids = new OID[this.searchRanges.size()];
                for (int i = 0; i < oids.length; ++i) {
                    AgentXSearchRange sr = (AgentXSearchRange)((Object)this.searchRanges.get(i));
                    oids[i] = sr.getLowerBound();
                }
                this.agentXRequestPDU = new AgentXGetPDU(request.getContext(), oids);
                break;
            }
            case -95: {
                this.agentXRequestPDU = new AgentXGetNextPDU(request.getContext(), this.searchRanges.toArray(new MOScope[this.searchRanges.size()]));
                break;
            }
            default: {
                logger.error((Object)("Failed to create AgentX PDU for PDU type " + requestPDU.getType()));
            }
        }
    }

    private static short getMaxRepetitions(SnmpRequest request, PDU requestPDU) {
        int maxRep = requestPDU.getMaxRepetitions() - request.getCompleteRepetitions();
        maxRep = Math.max(0, maxRep);
        maxRep = Math.min(maxRep, AgentXMasterAgent.getMaxGetBulkRepetitions());
        return (short)maxRep;
    }

    public AgentXMasterSession getSession() {
        return this.registration.getSession();
    }

    public SubRequestIterator getReferences() {
        return new GetSubRequestIterator();
    }

    public String toString() {
        return this.getClass().getName() + "[" + super.toStringMembers() + ",searchRanges=" + this.searchRanges + "]";
    }

    class GetSubRequestIterator
    extends SubRequestIteratorSupport {
        protected GetSubRequestIterator() {
            super(AgentXPendingGet.this.searchRanges.iterator());
        }

        protected SubRequest mapToSubRequest(Object element) {
            return ((AgentXSearchRange)((Object)element)).getReferenceSubRequest();
        }
    }
}

