/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io.prop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class PropertyMOInput
implements MOInput {
    private static final LogAdapter logger = LogFactory.getLogger((Class)PropertyMOInput.class);
    public static final String CONFIG_PREFIX = "snmp4j.agent.cfg.";
    public static final String CONTEXTS_ID = "contexts";
    public static final String OID_ID = "oid.";
    public static final String INDEX_ID = "index.";
    public static final String VERSION_ID = "version.";
    public static final String CTX_ID = "ctx.";
    public static final String VALUE_ID = "value.";
    private static final int STATE_ALL_CTX_DATA_SEQ = 0;
    private static final int STATE_ALL_CTX_DATA = 1;
    private static final int STATE_CTX_SEQ = 2;
    private static final int STATE_CTX_DATA_SEQ = 3;
    private static final int STATE_CTX_DATA = 4;
    private int importMode = 1;
    private int state = 0;
    private SortedMap properties;
    private ContextInfo contexts;
    private OIDInfo oids;
    private DataInfo data;
    private VariableProvider variables;
    static /* synthetic */ Class class$org$snmp4j$smi$OctetString;
    static /* synthetic */ Class class$org$snmp4j$smi$OID;

    public PropertyMOInput(Properties props) {
        this.properties = PropertyMOInput.scanProperties(props);
        this.contexts = this.scanContexts(this.properties);
    }

    public PropertyMOInput(Properties props, VariableProvider variables) {
        this(props);
        this.variables = variables;
    }

    private ContextInfo scanContexts(Map properties) {
        String ctx = (String)properties.get("snmp4j.agent.cfg.contexts");
        StringTokenizer st = new StringTokenizer(ctx, ",");
        ArrayList<Context> l = new ArrayList<Context>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            OctetString s = (OctetString)this.createVariableFromString(token, class$org$snmp4j$smi$OctetString == null ? PropertyMOInput.class$("org.snmp4j.smi.OctetString") : class$org$snmp4j$smi$OctetString);
            l.add(new Context(s));
        }
        return new ContextInfo(l.size(), l.iterator());
    }

    private OIDInfo scanOIDs(SortedMap properties, OctetString ctx) {
        Map.Entry e;
        String k;
        String prefix = "snmp4j.agent.cfg.oid.";
        String ctxSuffix = "";
        if (ctx != null) {
            ctxSuffix = CTX_ID + ctx.toString() + ".";
        }
        prefix = prefix + ctxSuffix;
        SortedMap oids = properties.tailMap(prefix);
        ArrayList<MOInfo> l = new ArrayList<MOInfo>();
        Iterator it = oids.entrySet().iterator();
        while (it.hasNext() && (k = (e = it.next()).getKey()).startsWith(prefix)) {
            String oid = k.substring(prefix.length());
            String version = (String)properties.get("snmp4j.agent.cfg.version." + ctxSuffix);
            l.add(new MOInfo(new OID(oid), version));
        }
        return new OIDInfo(ctx, l.size(), l.iterator());
    }

    private DataInfo scanData(SortedMap properties, OctetString context, OID oid, boolean indexed) {
        String prefix = CONFIG_PREFIX;
        String ctxSuffix = "";
        if (context != null) {
            ctxSuffix = CTX_ID + context;
        }
        prefix = prefix + ctxSuffix;
        if (!indexed) {
            prefix = prefix + OID_ID + oid;
            String value = (String)properties.get(prefix);
            Variable v = this.createVariableFromString(value, Variable.class);
            return new DataInfo(context, 1, Arrays.asList(v).iterator());
        }
        prefix = prefix + OID_ID + oid;
        String dimension = (String)properties.get(prefix);
        StringTokenizer st = new StringTokenizer(dimension, ": ");
        int rows = Integer.parseInt(st.nextToken());
        int cols = Integer.parseInt(st.nextToken());
        String indexPrefix = CONFIG_PREFIX + ctxSuffix + INDEX_ID + oid;
        String valuePrefix = CONFIG_PREFIX + ctxSuffix + VALUE_ID + oid;
        ArrayList<IndexedVariables> l = new ArrayList<IndexedVariables>();
        for (int i = 0; i < rows; ++i) {
            String indexString = (String)properties.get(indexPrefix + "." + i);
            OID index = (OID)this.createVariableFromString(indexString, class$org$snmp4j$smi$OID == null ? PropertyMOInput.class$("org.snmp4j.smi.OID") : class$org$snmp4j$smi$OID);
            Variable[] v = new Variable[cols];
            for (int j = 0; j < cols; ++j) {
                String val = (String)properties.get(valuePrefix + "." + i + "." + j);
                if (val == null) continue;
                v[j] = this.createVariableFromString(val, class$org$snmp4j$smi$Variable == null ? PropertyMOInput.class$("org.snmp4j.smi.Variable") : class$org$snmp4j$smi$Variable);
            }
            l.add(new IndexedVariables(index, v));
        }
        return new DataInfo(context, l.size(), l.iterator());
    }

    private static SortedMap scanProperties(Properties props) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            if (!e.getKey().toString().startsWith(CONFIG_PREFIX)) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public int getImportMode() {
        return this.importMode;
    }

    public Context readContext() throws IOException {
        if (this.state == 2 && this.contexts != null) {
            return (Context)this.contexts.iterator.next();
        }
        throw new IOException();
    }

    public IndexedVariables readIndexedVariables() throws IOException {
        if (this.data == null) {
            this.data = this.scanData(this.properties, this.oids.curContext, this.oids.curOID.getOID(), true);
        }
        IndexedVariables ivar = (IndexedVariables)this.data.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read indexed variables " + ivar + " for OID " + this.oids.curOID.getOID() + " in context " + this.oids.curContext));
        }
        return ivar;
    }

    public MOInfo readManagedObject() throws IOException {
        MOInfo info = (MOInfo)this.oids.next();
        this.data = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read MO " + info));
        }
        return info;
    }

    public Sequence readSequence() throws IOException {
        switch (this.state) {
            case 0: {
                ++this.state;
                this.oids = this.scanOIDs(this.properties, null);
                return new Sequence(this.oids.numElements);
            }
            case 1: {
                if (this.data != null && !this.oids.iterator.hasNext()) {
                    ++this.state;
                } else {
                    this.data = this.scanData(this.properties, this.oids.curContext, this.oids.curOID.getOID(), true);
                    return new Sequence(this.data.numElements);
                }
            }
            case 2: {
                ++this.state;
                return new Sequence(this.contexts.numContexts);
            }
        }
        return null;
    }

    public Variable readVariable() throws IOException {
        if (this.data == null) {
            this.data = this.scanData(this.properties, this.oids.curContext, this.oids.curOID.getOID(), false);
        }
        Variable v = (Variable)this.data.next();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read variable " + v + " for OID " + this.oids.curOID.getOID() + " in context " + this.oids.curContext));
        }
        return v;
    }

    public void skipContext(Context context) throws IOException {
    }

    public void skipManagedObject(MOInfo mo) throws IOException {
    }

    public Variable createVariableFromString(String value, Class returnType) {
        if (value != null) {
            Null variable;
            char type = ' ';
            String varName = null;
            if (value.length() >= 3) {
                type = value.charAt(1);
                int pos = value.indexOf(125);
                if (type == '$') {
                    varName = value.substring(2, pos);
                }
                value = value.substring(pos + 1);
            }
            switch (type) {
                case 'i': {
                    variable = new Integer32(Integer.parseInt(value));
                    break;
                }
                case 'u': {
                    variable = new UnsignedInteger32(Long.parseLong(value));
                    break;
                }
                case 's': {
                    variable = new OctetString(value);
                    break;
                }
                case 'x': {
                    variable = OctetString.fromString((String)value, (char)':', (int)16);
                    break;
                }
                case 'd': {
                    variable = OctetString.fromString((String)value, (char)'.', (int)10);
                    break;
                }
                case 'b': {
                    variable = OctetString.fromString((String)value, (char)' ', (int)2);
                    break;
                }
                case 'n': {
                    variable = new Null();
                    break;
                }
                case 'o': {
                    try {
                        variable = new OID(value);
                    }
                    catch (Exception ex) {
                        Pattern p = Pattern.compile("(\\$#?\\{[^\\}]*\\})");
                        Matcher m = p.matcher(value);
                        StringBuffer result = new StringBuffer();
                        while (m.find()) {
                            String group = m.group();
                            boolean impliedLength = true;
                            if (group.charAt(1) == '#') {
                                impliedLength = false;
                            }
                            group = group.substring(group.indexOf(123) + 1, group.length() - 1);
                            OID replacementValue = this.variables == null ? new OID() : this.variables.getVariable(group);
                            OID oid = replacementValue.toSubIndex(impliedLength);
                            m.appendReplacement(result, oid.toString());
                        }
                        m.appendTail(result);
                        variable = new OID(result.toString());
                    }
                    break;
                }
                case 't': {
                    variable = new TimeTicks(Long.parseLong(value));
                    break;
                }
                case 'a': {
                    variable = new IpAddress(value);
                    break;
                }
                case '$': {
                    variable = this.variables == null ? null : this.variables.getVariable(varName);
                    break;
                }
                case ' ': {
                    return null;
                }
                default: {
                    throw new IllegalArgumentException("Variable type " + type + " not supported");
                }
            }
            if (!returnType.isInstance(variable)) {
                // empty if block
            }
            return variable;
        }
        return null;
    }

    public void close() throws IOException {
    }

    private class DataInfo
    implements Iterator {
        int numElements;
        OctetString context;
        Iterator iterator;

        DataInfo(OctetString context, int numElements, Iterator data) {
            this.numElements = numElements;
            this.iterator = data;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }

    private class OIDInfo
    implements Iterator {
        int numElements;
        MOInfo curOID;
        OctetString curContext;
        Iterator iterator;

        OIDInfo(OctetString context, int numElements, Iterator data) {
            this.numElements = numElements;
            this.iterator = data;
            this.curContext = context;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.curOID = (MOInfo)this.iterator.next();
            return this.curOID;
        }
    }

    private class ContextInfo
    implements Iterator {
        int numContexts;
        OctetString curContext;
        Iterator iterator;

        ContextInfo(int numContexts, Iterator contexts) {
            this.numContexts = numContexts;
            this.iterator = contexts;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.curContext = (OctetString)this.iterator.next();
            return this.curContext;
        }
    }
}

