/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.snmp4j.agent.ContextEvent;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.UpdatableManagedObject;
import org.snmp4j.agent.UpdateStrategy;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class DefaultMOServer
implements MOServer {
    private static final LogAdapter logger = LogFactory.getLogger((Class)DefaultMOServer.class);
    private Set contexts;
    private SortedMap registry = Collections.synchronizedSortedMap(new TreeMap(new MOScopeComparator()));
    private Map lockList;
    private Map lookupListener;
    private transient Vector contextListeners;
    private UpdateStrategy updateStrategy;

    public DefaultMOServer() {
        this.contexts = new LinkedHashSet(10);
        this.lockList = new Hashtable(10);
    }

    public ManagedObject lookup(MOQuery query) {
        SortedMap scope = this.registry.tailMap(query);
        Iterator it = scope.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            MOScope key = (MOScope)((Object)entry.getKey());
            if (!DefaultMOContextScope.isContextMatching(query.getScope(), key)) continue;
            Object o = entry.getValue();
            if (o instanceof ManagedObject) {
                ManagedObject mo = (ManagedObject)o;
                MOScope moScope = mo.getScope();
                if (!query.getScope().isOverlapping(moScope)) continue;
                this.fireQueryEvent(mo, query);
                if (mo instanceof UpdatableManagedObject) {
                    this.checkForUpdate((UpdatableManagedObject)mo, query);
                }
                if (!query.matchesQuery(mo)) continue;
                this.fireLookupEvent(mo, query);
                return mo;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn((Object)("Object looked up is not a ManagedObject: " + o));
        }
        return null;
    }

    protected void checkForUpdate(UpdatableManagedObject mo, MOQuery query) {
        if (this.updateStrategy != null && this.updateStrategy.isUpdateNeeded(this, mo, query)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating UpdatableManagedObject " + mo + " on behalf of query " + query));
            }
            mo.update(query);
        }
    }

    public ManagedObject getManagedObject(OID key, OctetString context) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        return this.lookup(new DefaultMOQuery(scope));
    }

    protected void fireLookupEvent(ManagedObject mo, MOQuery query) {
        ArrayList l;
        if (this.lookupListener != null && (l = (ArrayList)this.lookupListener.get(mo)) != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query);
            l = new ArrayList(l);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MOServerLookupListener item = (MOServerLookupListener)it.next();
                item.lookupEvent(event);
            }
        }
    }

    protected void fireQueryEvent(ManagedObject mo, MOQuery query) {
        ArrayList l;
        if (this.lookupListener != null && (l = (ArrayList)this.lookupListener.get(mo)) != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query);
            l = new ArrayList(l);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MOServerLookupListener item = (MOServerLookupListener)it.next();
                item.queryEvent(event);
            }
        }
    }

    public OctetString[] getContexts() {
        return this.contexts.toArray(new OctetString[0]);
    }

    public boolean isContextSupported(OctetString context) {
        if (context == null || context.length() == 0) {
            return true;
        }
        return this.contexts.contains(context);
    }

    public SortedMap getRegistry() {
        return this.registry;
    }

    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void register(ManagedObject mo, OctetString context) throws DuplicateRegistrationException {
        if (context == null) {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(null, mo.getScope());
            ManagedObject other = this.lookup(new DefaultMOQuery(contextScope));
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(mo.getScope(), mo);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered MO " + mo + " in default context with scope " + mo.getScope()));
            }
        } else {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(context, mo.getScope());
            ManagedObject other = this.lookup(new DefaultMOQuery(contextScope));
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(contextScope, mo);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered MO " + mo + " in context " + context + " with scope " + contextScope));
            }
        }
    }

    public void unregister(ManagedObject mo, OctetString context) {
        MOScope key = context == null ? mo.getScope() : new DefaultMOContextScope(context, mo.getScope());
        Object r = this.registry.remove(key);
        if (r == null) {
            SortedMap tailMap = this.registry.tailMap(key);
            Iterator it = tailMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                MOScope entryKey = entry.getKey();
                if (!entry.getValue().equals(mo) || (context == null || !(entryKey instanceof MOContextScope) || !context.equals((Object)((MOContextScope)entryKey).getContext())) && context != null) continue;
                r = entry.getValue();
                it.remove();
                break;
            }
        }
        if (logger.isInfoEnabled()) {
            if (r != null) {
                logger.info((Object)("Removed registration " + r + " for " + mo + " in context '" + context + "' sucessfully"));
            } else {
                logger.warn((Object)("Removing registration failed for " + mo + " in context '" + context + "'"));
            }
        }
    }

    public void addContext(OctetString context) {
        this.contexts.add(context);
    }

    public void removeContext(OctetString context) {
        this.contexts.remove(context);
    }

    public synchronized boolean lock(Object owner, ManagedObject managedObject) {
        return this.lock(owner, managedObject, 0L);
    }

    public boolean lock(Object owner, ManagedObject managedObject, long timeoutMillis) {
        Lock lock;
        long start = System.currentTimeMillis();
        do {
            if ((lock = (Lock)this.lockList.get(managedObject)) == null) {
                this.lockList.put(managedObject, new Lock(owner));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Acquired lock on " + managedObject + " for " + owner));
                }
                return true;
            }
            if (lock.getOwner() != owner) {
                try {
                    while (lock.getCount() > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Waiting for lock on " + managedObject));
                        }
                        if (timeoutMillis <= 0L) {
                            this.wait();
                            continue;
                        }
                        this.wait(Math.max(timeoutMillis - (System.currentTimeMillis() - start), 1L));
                    }
                    continue;
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)("Waiting for lock on " + managedObject + " has been interrupted!"));
                    break;
                }
            }
            lock.add();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added lock on " + managedObject + " for " + owner));
            }
            return true;
        } while (lock != null && (timeoutMillis <= 0L || System.currentTimeMillis() - start < timeoutMillis));
        return false;
    }

    public synchronized void unlock(Object owner, ManagedObject managedObject) {
        Lock lock = (Lock)this.lockList.get(managedObject);
        if (lock == null) {
            return;
        }
        if (lock.getOwner() != owner) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Object '" + owner + "' is not owner of lock: " + lock));
            }
            return;
        }
        if (lock.remove()) {
            this.lockList.remove(managedObject);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed lock on " + managedObject + " by " + owner));
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        SortedMap m;
        SortedMap sortedMap = m = this.getRegistry();
        synchronized (sortedMap) {
            TreeMap r = new TreeMap(new MOScopeComparator());
            r.putAll(m);
            return r.entrySet().iterator();
        }
    }

    public synchronized void addLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List<MOServerLookupListener> l;
        if (this.lookupListener == null) {
            this.lookupListener = Collections.synchronizedMap(new HashMap());
        }
        if ((l = (List<MOServerLookupListener>)this.lookupListener.get(mo)) == null) {
            l = Collections.synchronizedList(new LinkedList());
            this.lookupListener.put(mo, l);
        }
        l.add(listener);
    }

    public synchronized boolean removeLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List l;
        if (this.lookupListener != null && (l = (List)this.lookupListener.get(mo)) != null) {
            return l.remove(listener);
        }
        return false;
    }

    public synchronized void addContextListener(ContextListener l) {
        if (this.contextListeners == null) {
            this.contextListeners = new Vector(2);
        }
        this.contextListeners.add(l);
    }

    public synchronized void removeContextListener(ContextListener l) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(l);
        }
    }

    protected void fireContextChanged(ContextEvent event) {
        if (this.contextListeners != null) {
            Vector listeners = this.contextListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ContextListener)listeners.elementAt(i)).contextChanged(event);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("[contexts=" + this.contexts);
        buf.append("[keys={");
        Iterator it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            MOScope scope = (MOScope)it.next();
            buf.append(scope.getLowerBound());
            if (scope.isLowerIncluded()) {
                buf.append("+");
            }
            buf.append("-");
            buf.append(scope.getUpperBound());
            if (scope.isUpperIncluded()) {
                buf.append("+");
            }
            if (scope instanceof MOContextScope) {
                buf.append("(" + ((MOContextScope)scope).getContext() + ")");
            }
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        buf.append(",registry=" + this.registry);
        buf.append(",lockList=" + this.lockList);
        buf.append(",lookupListener=" + this.lookupListener);
        buf.append("]");
        return buf.toString();
    }

    static class Lock {
        private Object owner;
        private long creationTime = System.currentTimeMillis();
        private int count = 0;

        private Lock() {
        }

        Lock(Object owner) {
            this();
            this.owner = owner;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void add() {
            ++this.count;
        }

        public synchronized boolean remove() {
            return --this.count <= 0;
        }

        public Object getOwner() {
            return this.owner;
        }
    }
}

