/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.agentx.master.AgentXMasterAgent;
import org.snmp4j.agent.cfg.EngineBootsCounterFile;
import org.snmp4j.agent.cfg.EngineBootsProvider;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.JavaLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TestMasterAgent {
    public static LogAdapter logger;
    protected String address;
    protected TransportMapping masterTransport;
    protected AgentXMasterAgent agent;
    protected MOServer server;
    private String configFile;
    private File bootCounterFile;

    public TestMasterAgent(Map args) throws IOException {
        this.configFile = (String)((List)args.get("c")).get(0);
        this.bootCounterFile = new File((String)((List)args.get("bc")).get(0));
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses((MessageDispatcher)messageDispatcher, (List)args.get("address"));
        this.agent = new AgentXMasterAgent(new OctetString(MPv3.createLocalEngineID()), (MessageDispatcher)messageDispatcher, null, moServers, (WorkerPool)ThreadPool.create((String)"SampleAgent", (int)3), null, (MOPersistenceProvider)new DefaultMOPersistenceProvider(moServers, this.configFile), (EngineBootsProvider)new EngineBootsCounterFile(this.bootCounterFile)){

            public void configure() {
                super.configure();
                TestMasterAgent.this.addCommunities(this.communityMIB);
                TestMasterAgent.this.addUsmUser(this.usm);
                TestMasterAgent.this.addNotificationTargets(this.targetMIB, this.notificationMIB);
                TestMasterAgent.this.addViews(this.vacmMIB);
            }
        };
    }

    protected void addListenAddresses(MessageDispatcher md, List addresses) {
        Iterator it = addresses.iterator();
        while (it.hasNext()) {
            Address address = GenericAddress.parse((String)((String)it.next()));
            TransportMapping tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                md.addTransportMapping(tm);
                continue;
            }
            logger.warn((Object)("No transport mapping available for address '" + address + "'."));
        }
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        targetMIB.addTargetAddress(new OctetString("notification"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("v2c"), 4);
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 2, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.agent.getLocalEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    protected void addUsmUser(USM usm) {
        UsmUser user = new UsmUser(new OctetString("SHADES"), AuthSHA.ID, new OctetString("SHADESAuthPassword"), PrivDES.ID, new OctetString("SHADESPrivPassword"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("TEST"), AuthSHA.ID, new OctetString("maplesyrup"), PrivDES.ID, new OctetString("maplesyrup"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("SHA"), AuthSHA.ID, new OctetString("SHAAuthPassword"), null, null);
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("-c[s{=SampleAgent.cfg}] -bc[s{=SampleAgent.bc}] -X[s{=tcp:0.0.0.0/705}<tcp:.*[/[0-9]+]?>] +h +v", "#address[s<(udp|tcp):.*[/[0-9]+]?>] ..");
        Map commandLineParameters = null;
        try {
            commandLineParameters = parser.parse(args);
            if (commandLineParameters.containsKey("h")) {
                TestMasterAgent.printUsage();
                System.exit(0);
            }
            if (commandLineParameters.containsKey("v")) {
                System.out.println("Options: " + commandLineParameters);
            }
            TestMasterAgent sampleAgent = new TestMasterAgent(commandLineParameters);
            String agentXAddress = ((String)((List)commandLineParameters.get("X")).get(0)).substring(4);
            sampleAgent.agent.addAgentXTransportMapping((TransportMapping)new DefaultTcpTransportMapping(new TcpAddress(agentXAddress)));
            sampleAgent.agent.run();
            sampleAgent.agent.getCommandProcessor().setAcceptNewContexts(true);
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex1) {
            }
        }
        catch (ArgumentParser.ArgumentParseException ax) {
            TestMasterAgent.printUsage();
            System.out.println(ax.getMessage());
        }
        catch (Exception ex) {
            logger.fatal((Object)"Caught exception while starting the agent", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    static void printUsage() {
        String[] txt = new String[]{"Usage: TestMasterAgent [-c <config-file>] [-bc <boot-counter-file>] [-h] [-v]", "                       [-X <masterAddress>] <address1> [<address2> ..]", "", "where ", "  <config-file>        is the file where persistent MIB data is stored/read.", "  <boot-counter-file>  is the file to store the SNMPv3 boot counter.", "  -h                   prints this usage help information and exit.", "  -v                   print command line parameters.", "  <masterAddress>      is the TCP AgentX master agent address of the local", "                       host following the format 'tcp:<host>/<port>'.", "  <address>            a listen address following the format ", "                       'udp|tcp:<host>/<port>', for example udp:0.0.0.0/161", ""};
        for (int i = 0; i < txt.length; ++i) {
            System.out.println(txt[i]);
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new JavaLogFactory());
        logger = LogFactory.getLogger((Class)TestMasterAgent.class);
    }
}

