/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class AgentXRegisterPDU
extends AgentXContextPDU {
    private byte timeout = 0;
    private byte priority;
    private byte rangeSubID;
    private OID subtree;
    private int upperBound;

    public AgentXRegisterPDU(byte flags, int sessionID, int transactionID, int packetID) {
        super((byte)3, flags, sessionID, transactionID, packetID);
    }

    public AgentXRegisterPDU(AgentXMessageHeader header) {
        super(header);
    }

    public AgentXRegisterPDU(OctetString context, OID subtree, byte priority, byte rangeSubID, int upperBound) {
        this(3, context, subtree, priority, rangeSubID, upperBound);
    }

    protected AgentXRegisterPDU(byte type, OctetString context, OID subtree, byte priority, byte rangeSubID, int upperBound) {
        super(type, context);
        this.priority = priority;
        this.subtree = subtree;
        this.rangeSubID = rangeSubID;
        this.upperBound = upperBound;
    }

    public void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.timeout = buf.get();
        this.priority = buf.get();
        this.rangeSubID = buf.get();
        buf.get();
        this.subtree = new OID();
        AgentXProtocol.decodeOID(buf, this.subtree);
        if (this.rangeSubID != 0) {
            this.upperBound = buf.getInt();
            if (this.rangeSubID < 0 || this.rangeSubID > this.subtree.size()) {
                throw new IOException("Range sub-identifier " + this.rangeSubID + " is out of range of " + this.subtree);
            }
        }
    }

    public OctetString getContext() {
        return this.context;
    }

    public byte getPriority() {
        return this.priority;
    }

    public byte getRangeSubID() {
        return this.rangeSubID;
    }

    public OID getSubtree() {
        return this.subtree;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setContext(OctetString context) {
        this.context = context;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setRangeSubID(byte rangeSubID) {
        this.rangeSubID = rangeSubID;
    }

    public void setSubtree(OID subtree) {
        this.subtree = subtree;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public int getAfterContextLength() {
        return 4 + AgentXProtocol.getOIDLength(this.subtree) + (this.rangeSubID != 0 ? 4 : 0);
    }

    public AgentXRegion getRegion() {
        OID lower = new OID(this.subtree);
        OID upper = new OID(this.subtree);
        AgentXRegion region = new AgentXRegion(lower, upper);
        if (this.rangeSubID > 0) {
            if (upper.get(this.rangeSubID - 1) == this.upperBound) {
                region.setSingleOID(true);
                region.setUpperIncluded(true);
            } else {
                upper.set(this.rangeSubID - 1, this.upperBound);
                region.setRangeSubID(this.rangeSubID);
            }
        } else if (this.isFlagSet(1)) {
            region.setSingleOID(true);
            region.setUpperIncluded(true);
        } else {
            region.setUpperBound(upper.nextPeer());
        }
        return region;
    }

    protected void encodeAfterContext(ByteBuffer buf) {
        buf.put(this.timeout);
        buf.put(this.priority);
        buf.put(this.rangeSubID);
        buf.put((byte)0);
        AgentXProtocol.encodeOID(buf, this.subtree, false);
        if (this.rangeSubID != 0) {
            buf.putInt(this.upperBound);
        }
    }

    protected String toStringExtMembers() {
        return super.toStringExtMembers() + ",timeout=" + this.timeout + ",priority=" + this.priority + ",rangeSubID=" + this.rangeSubID + ",subtree=" + this.subtree + ",upperBound=" + this.upperBound + ",single=" + this.isFlagSet(1);
    }
}

