/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Comparator;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.smi.OctetString;

public class MOScopeComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        int result = 0;
        if (o2 instanceof MOQuery) {
            result = !(o1 instanceof MOScope) ? this.compare(((MOQuery)o1).getScope(), ((MOQuery)o2).getScope()) : MOScopeComparator.compareScopeAndQuery((MOScope)o1, (MOQuery)o2);
        } else if (o1 instanceof MOQuery) {
            result = -MOScopeComparator.compareScopeAndQuery((MOScope)o2, (MOQuery)o1);
        } else {
            MOScope s1 = (MOScope)o1;
            MOScope s2 = (MOScope)o2;
            if (s1 instanceof MOContextScope && s2 instanceof MOContextScope) {
                OctetString c1 = ((MOContextScope)s1).getContext();
                OctetString c2 = ((MOContextScope)s2).getContext();
                if (c1 != null && c2 != null) {
                    result = c1.compareTo((Object)c2);
                }
            }
            if (result == 0 && (result = s1.getLowerBound().compareTo((Object)s2.getLowerBound())) == 0) {
                result = s1 instanceof MOContextScope ? -1 : 1;
            }
        }
        return result;
    }

    private static int compareScopeAndQuery(MOScope scope, MOQuery query) {
        int result = 0;
        if (scope instanceof MOContextScope) {
            OctetString c1 = ((MOContextScope)scope).getContext();
            OctetString c2 = query.getScope().getContext();
            if (c1 != null && c2 != null) {
                result = c1.compareTo((Object)c2);
            }
        }
        if (result != 0) {
            return result;
        }
        if (scope.getUpperBound() == null) {
            return 1;
        }
        result = scope.getUpperBound().compareTo((Object)query.getScope().getLowerBound());
        if (!(result != 0 || scope.isUpperIncluded() && query.getScope().isLowerIncluded())) {
            return -1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

