/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.request.AbstractRequest;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.RequestStatusEvent;
import org.snmp4j.agent.request.RequestStatusListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SnmpRequest
extends AbstractRequest<SnmpSubRequest, CommandResponderEvent, PDU> {
    private static final LogAdapter logger = LogFactory.getLogger(SnmpRequest.class);
    public static final OctetString DEFAULT_CONTEXT = new OctetString();
    private CoexistenceInfo coexistenceInfo;
    private OctetString viewName;
    private static int nextTransactionID = 0;
    protected Map processingUserObjects;

    public SnmpRequest(CommandResponderEvent request, CoexistenceInfo cinfo) {
        super(request);
        this.coexistenceInfo = cinfo;
        this.correctRequestValues();
        this.transactionID = SnmpRequest.nextTransactionID();
    }

    public static synchronized int nextTransactionID() {
        return nextTransactionID++;
    }

    @Override
    protected synchronized void setupSubRequests() {
        int capacity = ((CommandResponderEvent)this.source).getPDU().size();
        int totalRepetitions = ((CommandResponderEvent)this.source).getPDU() instanceof PDUv1 ? 0 : this.repeaterRowSize * ((CommandResponderEvent)this.source).getPDU().getMaxRepetitions();
        this.subrequests = new ArrayList(capacity + totalRepetitions);
        if (this.response == null) {
            this.response = this.createResponse();
        }
        for (int i = 0; i < ((CommandResponderEvent)this.source).getPDU().size(); ++i) {
            SnmpSubRequest subReq = new SnmpSubRequest(((CommandResponderEvent)this.source).getPDU().get(i), i);
            this.addSubRequest(subReq);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("SnmpSubRequests initialized: " + this.subrequests)));
        }
    }

    public synchronized int getCompleteRepetitions() {
        int i = 0;
        for (SnmpSubRequest sreq : this.subrequests) {
            if (!sreq.isComplete()) {
                return i / this.getRepeaterCount();
            }
            ++i;
        }
        return i / this.getRepeaterCount();
    }

    public int getMaxRepetitions() {
        return ((CommandResponderEvent)this.source).getPDU().getMaxRepetitions();
    }

    public int getNonRepeaters() {
        return ((CommandResponderEvent)this.source).getPDU().getNonRepeaters();
    }

    private void addSubRequest(SnmpSubRequest subReq) {
        this.subrequests.add(subReq);
        ((PDU)this.response).add(subReq.getVariableBinding());
    }

    @Override
    protected int getMaxPhase() {
        return this.is2PC() ? 4 : 0;
    }

    @Override
    public int size() {
        return ((CommandResponderEvent)this.source).getPDU().size();
    }

    public CommandResponderEvent getInitiatingEvent() {
        return (CommandResponderEvent)this.source;
    }

    public void setRequestEvent(CommandResponderEvent source) {
        this.source = source;
    }

    protected void assignErrorStatus2Response() {
        int errStatus = this.getErrorStatus();
        if (((CommandResponderEvent)this.source).getMessageProcessingModel() == 0) {
            switch (errStatus) {
                case 6: 
                case 11: 
                case 17: 
                case 18: {
                    ((PDU)this.response).setErrorStatus(2);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    ((PDU)this.response).setErrorStatus(5);
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    ((PDU)this.response).setErrorStatus(3);
                    break;
                }
                default: {
                    ((PDU)this.response).setErrorStatus(errStatus);
                }
            }
            for (int i = 0; i < ((PDU)this.response).size(); ++i) {
                VariableBinding vb = ((PDU)this.response).get(i);
                if (!vb.isException()) continue;
                ((PDU)this.response).setErrorStatus(2);
                ((PDU)this.response).setErrorIndex(i + 1);
                ((PDU)this.response).set(i, new VariableBinding(vb.getOid()));
                return;
            }
        } else {
            ((PDU)this.response).setErrorStatus(errStatus);
        }
        ((PDU)this.response).setErrorIndex(this.getErrorIndex());
    }

    private PDU createResponse() {
        PDU resp = (PDU)((CommandResponderEvent)this.source).getPDU().clone();
        resp.clear();
        resp.setType(-94);
        resp.setRequestID(((CommandResponderEvent)this.source).getPDU().getRequestID());
        resp.setErrorIndex(0);
        resp.setErrorStatus(0);
        return resp;
    }

    private void correctRequestValues() {
        PDU request = ((CommandResponderEvent)this.source).getPDU();
        if (!(request instanceof PDUv1)) {
            if (request.getMaxRepetitions() < 0) {
                request.setMaxRepetitions(0);
            }
            if (request.getNonRepeaters() < 0) {
                request.setNonRepeaters(0);
            }
            this.repeaterStartIndex = request.getNonRepeaters();
            this.repeaterRowSize = Math.max(request.size() - this.repeaterStartIndex, 0);
        } else {
            this.repeaterStartIndex = 0;
            this.repeaterRowSize = request.size();
        }
    }

    public PDU getResponsePDU() {
        return this.getResponse();
    }

    @Override
    public PDU getResponse() {
        if (this.response == null) {
            this.response = this.createResponse();
        }
        this.assignErrorStatus2Response();
        return (PDU)this.response;
    }

    @Override
    public Iterator<SubRequest> iterator() {
        this.initSubRequests();
        return new SnmpSubRequestIterator();
    }

    protected boolean is2PC() {
        return ((CommandResponderEvent)this.source).getPDU().getType() == -93;
    }

    @Override
    public OctetString getContext() {
        if (this.coexistenceInfo != null) {
            return this.coexistenceInfo.getContextName();
        }
        if (((CommandResponderEvent)this.source).getPDU() instanceof ScopedPDU) {
            return ((ScopedPDU)((CommandResponderEvent)this.source).getPDU()).getContextName();
        }
        return DEFAULT_CONTEXT;
    }

    @Override
    public OctetString getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(OctetString viewName) {
        this.viewName = viewName;
    }

    @Override
    public int getSecurityLevel() {
        return ((CommandResponderEvent)this.source).getSecurityLevel();
    }

    @Override
    public int getSecurityModel() {
        return ((CommandResponderEvent)this.source).getSecurityModel();
    }

    @Override
    public OctetString getSecurityName() {
        if (this.coexistenceInfo != null) {
            return this.coexistenceInfo.getSecurityName();
        }
        return new OctetString(((CommandResponderEvent)this.source).getSecurityName());
    }

    @Override
    public int getViewType() {
        return SnmpRequest.getViewType(((CommandResponderEvent)this.source).getPDU().getType());
    }

    public static int getViewType(int pduType) {
        switch (pduType) {
            case -96: 
            case -95: 
            case -91: {
                return 1;
            }
            case -92: 
            case -90: 
            case -89: {
                return 0;
            }
        }
        return 2;
    }

    protected synchronized void addRepeaterSubRequest() {
        int predecessorIndex = this.subrequests.size() - this.repeaterRowSize;
        SnmpSubRequest sreq = new SnmpSubRequest((SnmpSubRequest)this.subrequests.get(predecessorIndex), this.subrequests.size());
        this.addSubRequest(sreq);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Added sub request '" + sreq + "' to response '" + this.response + "'")));
        }
    }

    @Override
    public int getErrorIndex() {
        if (this.errorStatus == 0) {
            return 0;
        }
        this.initSubRequests();
        int index = 1;
        for (SubRequest sreq : this.subrequests) {
            if (sreq.getStatus().getErrorStatus() != 0) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    @Override
    public int getTransactionID() {
        return this.transactionID;
    }

    public CoexistenceInfo getCoexistenceInfo() {
        return this.coexistenceInfo;
    }

    private List<SnmpSubRequest> lastRow(int upperBoundIndex) {
        if (this.repeaterRowSize == 0 || upperBoundIndex <= this.repeaterStartIndex) {
            return null;
        }
        int rows = (upperBoundIndex - this.repeaterStartIndex) / this.repeaterRowSize;
        int startIndex = this.repeaterStartIndex + this.repeaterRowSize * (rows - 1);
        int endIndex = this.repeaterStartIndex + this.repeaterRowSize * rows;
        if (startIndex < this.repeaterStartIndex || endIndex > this.subrequests.size()) {
            return null;
        }
        return this.subrequests.subList(startIndex, endIndex);
    }

    @Override
    public int getMessageProcessingModel() {
        return ((CommandResponderEvent)this.source).getMessageProcessingModel();
    }

    public int getRepeaterCount() {
        PDU reqPDU = ((CommandResponderEvent)this.source).getPDU();
        return Math.max(reqPDU.size() - reqPDU.getNonRepeaters(), 0);
    }

    @Override
    public boolean isPhaseComplete() {
        if (this.errorStatus == 0) {
            this.initSubRequests();
            for (Object subrequest : this.subrequests) {
                SubRequest subreq = (SubRequest)subrequest;
                RequestStatus status = subreq.getStatus();
                if (status.getErrorStatus() != 0) {
                    return true;
                }
                if (status.isPhaseComplete()) continue;
                return false;
            }
        }
        if (((CommandResponderEvent)this.source).getPDU().getType() == -91) {
            SnmpSubRequestIterator it = new SnmpSubRequestIterator(this.subrequests.size(), 1);
            return !it.hasNext();
        }
        return true;
    }

    @Override
    public boolean isBulkRequest() {
        return ((CommandResponderEvent)this.source).getPDU().getType() == -91;
    }

    @Override
    public synchronized Object getProcessingUserObject(Object key) {
        if (this.processingUserObjects != null) {
            return this.processingUserObjects.get(key);
        }
        return null;
    }

    @Override
    public synchronized Object setProcessingUserObject(Object key, Object value) {
        if (this.processingUserObjects == null) {
            this.processingUserObjects = new HashMap(5);
        }
        return this.processingUserObjects.put(key, value);
    }

    public class SnmpSubRequest
    implements org.snmp4j.agent.request.SnmpSubRequest,
    RequestStatusListener {
        private RequestStatus status;
        private VariableBinding vb;
        private Object undoValue;
        private MOScope scope;
        private ManagedObject targetMO;
        private MOQuery query;
        private int index;
        private volatile Object userObject;

        protected SnmpSubRequest(VariableBinding subrequest, int index) {
            this.vb = subrequest;
            this.index = index;
            switch (((CommandResponderEvent)SnmpRequest.this.source).getPDU().getType()) {
                case -95: 
                case -91: {
                    this.scope = this.getNextScope(new OID(this.vb.getOid()));
                    break;
                }
                default: {
                    OID oid = this.vb.getOid();
                    this.scope = new DefaultMOContextScope(SnmpRequest.this.getContext(), oid, true, oid, true);
                }
            }
            this.status = new RequestStatus();
            this.status.addRequestStatusListener(this);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Created subrequest " + index + " with scope " + this.scope + " from " + subrequest)));
            }
        }

        protected MOScope getNextScope(OID previousOID) {
            return new DefaultMOContextScope(SnmpRequest.this.getContext(), previousOID, false, null, false);
        }

        protected SnmpSubRequest(SnmpSubRequest predecessor, int index) {
            this(new VariableBinding(predecessor.getVariableBinding().getOid()), index);
        }

        public Request getRequest() {
            return SnmpRequest.this;
        }

        @Override
        public RequestStatus getStatus() {
            return this.status;
        }

        @Override
        public VariableBinding getVariableBinding() {
            return this.vb;
        }

        @Override
        public void setStatus(RequestStatus status) {
            this.status = status;
        }

        @Override
        public Object getUndoValue() {
            return this.undoValue;
        }

        @Override
        public void setUndoValue(Object undoInformation) {
            this.undoValue = undoInformation;
        }

        @Override
        public void requestStatusChanged(RequestStatusEvent event) {
            int newStatus = event.getStatus().getErrorStatus();
            this.setErrorStatus(newStatus);
            if (logger.isDebugEnabled() && newStatus != 0) {
                new Exception("Error '" + PDU.toErrorStatusText((int)event.getStatus().getErrorStatus()) + "' generated at: " + this.vb).printStackTrace();
            }
        }

        @Override
        public MOScope getScope() {
            return this.scope;
        }

        @Override
        public void completed() {
            this.status.setPhaseComplete(true);
        }

        @Override
        public boolean hasError() {
            return this.getStatus().getErrorStatus() != 0;
        }

        @Override
        public boolean isComplete() {
            return this.status.isPhaseComplete();
        }

        @Override
        public void setTargetMO(ManagedObject managedObject) {
            this.targetMO = managedObject;
        }

        @Override
        public ManagedObject getTargetMO() {
            return this.targetMO;
        }

        @Override
        public SnmpRequest getSnmpRequest() {
            return SnmpRequest.this;
        }

        @Override
        public void setErrorStatus(int errorStatus) {
            SnmpRequest.this.setErrorStatus(errorStatus);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setQuery(MOQuery query) {
            this.query = query;
        }

        @Override
        public MOQuery getQuery() {
            return this.query;
        }

        public String toString() {
            return this.getClass().getName() + "[scope=" + this.scope + ",vb=" + this.vb + ",status=" + this.status + ",query=" + this.query + ",index=" + this.index + ",targetMO=" + this.targetMO + "]";
        }

        @Override
        public SubRequestIterator repetitions() {
            return this.repetitions(false);
        }

        private SubRequestIterator repetitions(boolean noAppending) {
            SnmpRequest.this.initSubRequests();
            if (SnmpRequest.this.isBulkRequest()) {
                int repeaters = ((CommandResponderEvent)SnmpRequest.this.source).getPDU().size() - ((CommandResponderEvent)SnmpRequest.this.source).getPDU().getNonRepeaters();
                SnmpSubRequestIterator it = new SnmpSubRequestIterator(this.getIndex(), repeaters);
                it.setNoAppending(noAppending);
                return it;
            }
            return new SubRequestIteratorSupport(Collections.EMPTY_LIST.iterator());
        }

        @Override
        public void updateNextRepetition() {
            if (!SnmpRequest.this.isBulkRequest()) {
                return;
            }
            this.query = null;
            SubRequestIterator repetitions = this.repetitions(true);
            repetitions.next();
            while (repetitions.hasNext()) {
                SnmpSubRequest nsreq = (SnmpSubRequest)repetitions.next();
                if (this.getStatus().getErrorStatus() == 0 && !this.vb.isException()) {
                    nsreq.query = null;
                    nsreq.scope = this.getNextScope(this.vb.getOid());
                    nsreq.getVariableBinding().setOid(this.vb.getOid());
                    continue;
                }
                if (!this.vb.isException()) continue;
                nsreq.query = null;
                nsreq.getVariableBinding().setOid(this.vb.getOid());
                nsreq.getVariableBinding().setVariable(this.vb.getVariable());
                nsreq.getStatus().setPhaseComplete(true);
            }
        }

        @Override
        public final int getErrorStatus() {
            return this.getStatus().getErrorStatus();
        }

        @Override
        public Object getUserObject() {
            return this.userObject;
        }

        @Override
        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }

    public class SnmpSubRequestIterator
    implements SubRequestIterator {
        private int cursor = 0;
        private int increment = 1;
        private boolean noAppending;

        protected SnmpSubRequestIterator() {
            this.cursor = 0;
        }

        protected SnmpSubRequestIterator(int offset, int increment) {
            this.cursor = offset;
            this.increment = increment;
        }

        protected void setNoAppending(boolean noAppending) {
            this.noAppending = noAppending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            SnmpRequest snmpRequest = SnmpRequest.this;
            synchronized (snmpRequest) {
                PDU reqPDU = ((CommandResponderEvent)SnmpRequest.this.source).getPDU();
                if (reqPDU.getType() == -91) {
                    if (this.noAppending && this.cursor >= SnmpRequest.this.subrequests.size()) {
                        return false;
                    }
                    if (this.cursor < Math.min(reqPDU.size(), reqPDU.getNonRepeaters())) {
                        return true;
                    }
                    if (this.cursor < reqPDU.getNonRepeaters() + reqPDU.getMaxRepetitions() * SnmpRequest.this.getRepeaterCount()) {
                        List lastRow = SnmpRequest.this.lastRow(this.cursor);
                        if (lastRow != null) {
                            boolean allEndOfMibView = true;
                            SnmpSubRequest sreq = null;
                            for (SnmpSubRequest creq : lastRow) {
                                sreq = creq;
                                if (sreq.getVariableBinding().getSyntax() == 130) continue;
                                allEndOfMibView = false;
                                break;
                            }
                            if (allEndOfMibView) {
                                if (sreq != null && sreq.getIndex() < SnmpRequest.this.subrequests.size()) {
                                    int lastElementIndex = sreq.getIndex();
                                    List tail = SnmpRequest.this.subrequests.subList(lastElementIndex + 1, SnmpRequest.this.subrequests.size());
                                    tail.clear();
                                    tail = ((PDU)SnmpRequest.this.response).getVariableBindings().subList(lastElementIndex + 1, ((PDU)SnmpRequest.this.response).size());
                                    tail.clear();
                                }
                                return false;
                            }
                        }
                        return ((PDU)SnmpRequest.this.response).getBERLength() < ((CommandResponderEvent)SnmpRequest.this.source).getMaxSizeResponsePDU();
                    }
                    if (reqPDU.getNonRepeaters() == 0 && reqPDU.getMaxRepetitions() == 0) {
                        SnmpRequest.this.subrequests.clear();
                        if (SnmpRequest.this.response != null) {
                            while (((PDU)SnmpRequest.this.response).size() > 0) {
                                ((PDU)SnmpRequest.this.response).remove(0);
                            }
                        }
                    }
                    return false;
                }
                return this.cursor < reqPDU.size();
            }
        }

        @Override
        public SubRequest next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (((CommandResponderEvent)SnmpRequest.this.source).getPDU().getType() == -91 && this.cursor >= SnmpRequest.this.subrequests.size()) {
                while (this.cursor >= SnmpRequest.this.subrequests.size()) {
                    SnmpRequest.this.addRepeaterSubRequest();
                }
            }
            SubRequest sreq = (SubRequest)SnmpRequest.this.subrequests.get(this.cursor);
            this.cursor += this.increment;
            return sreq;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported on sub-requests");
        }

        public boolean equals(Object other) {
            return other instanceof Request && ((Request)other).getTransactionID() == SnmpRequest.this.getTransactionID();
        }

        public int hashCode() {
            return SnmpRequest.this.getTransactionID();
        }
    }
}

