/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp4j;

import org.snmp4j.Session;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.agent.mo.snmp4j.MOSubtreeProxy;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class Snmp4jProxyMib
implements MOGroup,
RowStatusListener,
MOTableRowListener {
    private static final LogAdapter LOGGER = LogFactory.getLogger(Snmp4jProxyMib.class);
    private MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmp4jProxyMib = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 3});
    private static final String TC_MODULE_SNMP_FRAMEWORK_MIB = "SNMP-FRAMEWORK-MIB";
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_SNMPADMINSTRING = "SnmpAdminString";
    private static final String TC_SNMPENGINEID = "SnmpEngineID";
    private static final String TC_STORAGETYPE = "StorageType";
    private static final String TC_ROWSTATUS = "RowStatus";
    public static final OID oidSnmp4jProxyEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 3, 1, 1, 1});
    public static final OID oidSnmp4jProxyName = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 3, 1, 1, 1, 1});
    public static final String tcModuleSnmpFrameworkMib = "SNMP-FRAMEWORK-MIB";
    public static final String tcDefSnmpEngineID = "SnmpEngineID";
    public static final String tcDefSnmpAdminString = "SnmpAdminString";
    public static final String tcModuleSNMPv2Tc = "SNMPv2-TC";
    public static final String tcDefStorageType = "StorageType";
    public static final String tcDefRowStatus = "RowStatus";
    public static final int colSnmp4jProxyContextEngineID = 2;
    public static final int colSnmp4jProxyContextName = 3;
    public static final int colSnmp4jProxySubtree = 4;
    public static final int colSnmp4jProxyType = 5;
    public static final int colSnmp4jProxyTarget = 6;
    public static final int colSnmp4jProxyStorageType = 7;
    public static final int colSnmp4jProxyRowStatus = 8;
    public static final int colSnmp4jProxyTargetSubtree = 9;
    public static final int idxSnmp4jProxyContextEngineID = 0;
    public static final int idxSnmp4jProxyContextName = 1;
    public static final int idxSnmp4jProxySubtree = 2;
    public static final int idxSnmp4jProxyType = 3;
    public static final int idxSnmp4jProxyTarget = 4;
    public static final int idxSnmp4jProxyStorageType = 5;
    public static final int idxSnmp4jProxyRowStatus = 6;
    public static final int idxSnmp4jProxyTargetSubtree = 7;
    private MOTableSubIndex[] snmp4jProxyEntryIndexes;
    private MOTableIndex snmp4jProxyEntryIndex;
    private MOTable snmp4jProxyEntry;
    private MOTableModel snmp4jProxyEntryModel;
    private Session session;
    private MOServer server;
    private SnmpTargetMIB targetMIB;

    protected Snmp4jProxyMib() {
    }

    protected Snmp4jProxyMib(MOFactory moFactory) {
        this();
        this.createMO(moFactory);
        this.snmp4jProxyEntry.addMOTableRowListener(this);
    }

    public Snmp4jProxyMib(MOFactory moFactory, Session session, MOServer server, SnmpTargetMIB targetMIB) {
        this(moFactory);
        this.session = session;
        this.server = server;
        this.targetMIB = targetMIB;
    }

    protected void createMO(MOFactory moFactory) {
        this.addTCsToFactory(moFactory);
        this.createSnmp4jProxyEntry(moFactory);
    }

    public MOTable getSnmp4jProxyEntry() {
        return this.snmp4jProxyEntry;
    }

    private void createSnmp4jProxyEntry(MOFactory moFactory) {
        this.snmp4jProxyEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidSnmp4jProxyName, 4, 1, 32)};
        this.snmp4jProxyEntryIndex = moFactory.createIndex(this.snmp4jProxyEntryIndexes, true);
        MOColumn[] snmp4jProxyEntryColumns = new MOColumn[8];
        snmp4jProxyEntryColumns[0] = new MOMutableColumn(2, 4, moFactory.createAccess(15), (Variable)((OctetString)null));
        ConstraintsImpl snmp4jProxyContextEngineIDVC = new ConstraintsImpl();
        snmp4jProxyContextEngineIDVC.add(new Constraint(5L, 32L));
        ((MOMutableColumn)snmp4jProxyEntryColumns[0]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyContextEngineIDVC));
        ((MOMutableColumn)snmp4jProxyEntryColumns[0]).addMOValueValidationListener(new Snmp4jProxyContextEngineIDValidator());
        snmp4jProxyEntryColumns[1] = new MOMutableColumn(3, 4, moFactory.createAccess(15), (Variable)new OctetString(new byte[0]));
        ConstraintsImpl snmp4jProxyContextNameVC = new ConstraintsImpl();
        snmp4jProxyContextNameVC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)snmp4jProxyEntryColumns[1]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyContextNameVC));
        ((MOMutableColumn)snmp4jProxyEntryColumns[1]).addMOValueValidationListener(new Snmp4jProxyContextNameValidator());
        snmp4jProxyEntryColumns[2] = new MOMutableColumn(4, 6, moFactory.createAccess(15), (Variable)((OID)null));
        ((MOMutableColumn)snmp4jProxyEntryColumns[2]).addMOValueValidationListener(new Snmp4jProxySubtreeValidator());
        snmp4jProxyEntryColumns[3] = new Enumerated<Integer32>(5, 2, moFactory.createAccess(15), new Integer32(1));
        EnumerationConstraint snmp4jProxyTypeVC = new EnumerationConstraint(new int[]{1, 2, 3});
        ((MOMutableColumn)snmp4jProxyEntryColumns[3]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyTypeVC));
        snmp4jProxyEntryColumns[4] = new MOMutableColumn(6, 4, moFactory.createAccess(15), (Variable)((OctetString)null));
        ConstraintsImpl snmp4jProxyTargetVC = new ConstraintsImpl();
        snmp4jProxyTargetVC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)snmp4jProxyEntryColumns[4]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyTargetVC));
        ((MOMutableColumn)snmp4jProxyEntryColumns[4]).addMOValueValidationListener(new Snmp4jProxyTargetValidator());
        snmp4jProxyEntryColumns[5] = new StorageType(7, moFactory.createAccess(15), (Integer32)null);
        EnumerationConstraint snmp4jProxyStorageTypeVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5});
        ((MOMutableColumn)snmp4jProxyEntryColumns[5]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyStorageTypeVC));
        ((MOMutableColumn)snmp4jProxyEntryColumns[5]).addMOValueValidationListener(new Snmp4jProxyStorageTypeValidator());
        snmp4jProxyEntryColumns[6] = new RowStatus(8);
        EnumerationConstraint snmp4jProxyRowStatusVC = new EnumerationConstraint(new int[]{1, 2, 3, 4, 5, 6});
        ((MOMutableColumn)snmp4jProxyEntryColumns[6]).addMOValueValidationListener(new ValueConstraintValidator(snmp4jProxyRowStatusVC));
        ((MOMutableColumn)snmp4jProxyEntryColumns[6]).addMOValueValidationListener(new Snmp4jProxyRowStatusValidator());
        snmp4jProxyEntryColumns[7] = new MOMutableColumn(9, 6, moFactory.createAccess(15), (Variable)new OID("0.0"));
        this.snmp4jProxyEntryModel = moFactory.createTableModel(oidSnmp4jProxyEntry, this.snmp4jProxyEntryIndex, snmp4jProxyEntryColumns);
        ((MOMutableTableModel)this.snmp4jProxyEntryModel).setRowFactory(new Snmp4jProxyEntryRowFactory());
        this.snmp4jProxyEntry = moFactory.createTable(oidSnmp4jProxyEntry, this.snmp4jProxyEntryIndex, snmp4jProxyEntryColumns, this.snmp4jProxyEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmp4jProxyEntry, context);
        ((RowStatus)this.snmp4jProxyEntry.getColumn(6)).addRowStatusListener(this);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmp4jProxyEntry, context);
        ((RowStatus)this.snmp4jProxyEntry.getColumn(6)).removeRowStatusListener(this);
    }

    @Override
    public void rowStatusChanged(RowStatusEvent event) {
        Snmp4jProxyEntryRow row = (Snmp4jProxyEntryRow)event.getRow();
        OctetString proxyName = new OctetString();
        proxyName.fromSubIndex(row.getIndex(), true);
        if (event.isRowActivated()) {
            int reason = this.registerProxy(row);
            if (reason != 0) {
                event.setDenyReason(reason);
            }
        } else if (event.isRowDeactivated()) {
            this.unregisterProxy(row);
        }
    }

    private void unregisterProxy(Snmp4jProxyEntryRow row) {
        MOSubtreeProxy proxy = (MOSubtreeProxy)row.getUserObject();
        if (proxy != null) {
            this.server.unregister(proxy, row.getSnmp4jProxyContextName());
        }
    }

    private int registerProxy(Snmp4jProxyEntryRow row) {
        OctetString proxyName = new OctetString();
        proxyName.fromSubIndex(row.getIndex(), true);
        MOSubtreeProxy proxy = new MOSubtreeProxy(this.session, this.targetMIB, proxyName, row.getSnmp4jProxySubtree(), row.getSnmp4jProxyContextEngineID(), row.getSnmp4jProxyContextName(), row.getSnmp4jProxyTarget());
        OID targetOID = row.getSnmp4jProxyTargetSubtree();
        if (targetOID != null && targetOID.size() > 0 && !SnmpConstants.zeroDotZero.equals((Object)targetOID)) {
            proxy.setTargetSubtree(targetOID);
        }
        try {
            this.server.register(proxy, row.getSnmp4jProxyContextName());
        }
        catch (DuplicateRegistrationException drex) {
            row.setSnmp4jProxyType(new Integer32(0));
            return 12;
        }
        row.setUserObject(proxy);
        return 0;
    }

    @Override
    public synchronized void rowChanged(MOTableRowEvent event) {
        Snmp4jProxyEntryRow row = (Snmp4jProxyEntryRow)event.getRow();
        switch (event.getType()) {
            case 1: {
                if (row.getSnmp4jProxyRowStatus().getValue() != 1) break;
                this.unregisterProxy(row);
                this.registerProxy(row);
                break;
            }
            case 3: {
                this.unregisterProxy(row);
            }
        }
    }

    protected void addTCsToFactory(MOFactory moFactory) {
    }

    public void addImportedTCsToFactory(MOFactory moFactory) {
        moFactory.addTextualConvention(new SnmpAdminString());
        moFactory.addTextualConvention(new SnmpEngineID());
    }

    public class SnmpEngineID
    implements TextualConvention {
        @Override
        public String getModuleName() {
            return "SNMP-FRAMEWORK-MIB";
        }

        @Override
        public String getName() {
            return "SnmpEngineID";
        }

        public Variable createInitialValue() {
            OctetString v = new OctetString();
            if (v instanceof AssignableFromLong) {
                ((AssignableFromLong)v).setValue(5L);
            }
            return v;
        }

        public MOScalar createScalar(OID oid, MOAccess access, Variable value) {
            MOScalar scalar = Snmp4jProxyMib.this.moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(5L, 32L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
            MOColumn col = Snmp4jProxyMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(5L, 32L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    public class SnmpAdminString
    implements TextualConvention {
        @Override
        public String getModuleName() {
            return "SNMP-FRAMEWORK-MIB";
        }

        @Override
        public String getName() {
            return "SnmpAdminString";
        }

        public Variable createInitialValue() {
            OctetString v = new OctetString();
            if (v instanceof AssignableFromLong) {
                ((AssignableFromLong)v).setValue(0L);
            }
            return v;
        }

        public MOScalar createScalar(OID oid, MOAccess access, Variable value) {
            MOScalar scalar = Snmp4jProxyMib.this.moFactory.createScalar(oid, access, value);
            ConstraintsImpl vc = new ConstraintsImpl();
            vc.add(new Constraint(0L, 255L));
            scalar.addMOValueValidationListener(new ValueConstraintValidator(vc));
            return scalar;
        }

        public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
            MOColumn col = Snmp4jProxyMib.this.moFactory.createColumn(columnID, syntax, access, defaultValue, mutableInService);
            if (col instanceof MOMutableColumn) {
                MOMutableColumn mcol = (MOMutableColumn)col;
                ConstraintsImpl vc = new ConstraintsImpl();
                vc.add(new Constraint(0L, 255L));
                mcol.addMOValueValidationListener(new ValueConstraintValidator(vc));
            }
            return col;
        }
    }

    class Snmp4jProxyEntryRowFactory
    extends DefaultMOMutableRow2PCFactory<Snmp4jProxyEntryRow> {
        Snmp4jProxyEntryRowFactory() {
        }

        @Override
        public synchronized Snmp4jProxyEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            Snmp4jProxyEntryRow row = new Snmp4jProxyEntryRow(index, values);
            return row;
        }

        @Override
        public synchronized void freeRow(Snmp4jProxyEntryRow row) {
        }
    }

    public class Snmp4jProxyEntryRow
    extends DefaultMOMutableRow2PC {
        public Snmp4jProxyEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getSnmp4jProxyContextEngineID() {
            return (OctetString)super.getValue(0);
        }

        public void setSnmp4jProxyContextEngineID(OctetString newValue) {
            super.setValue(0, (Variable)newValue);
        }

        public OctetString getSnmp4jProxyContextName() {
            return (OctetString)super.getValue(1);
        }

        public void setSnmp4jProxyContextName(OctetString newValue) {
            super.setValue(1, (Variable)newValue);
        }

        public OID getSnmp4jProxySubtree() {
            return (OID)super.getValue(2);
        }

        public void setSnmp4jProxySubtree(OID newValue) {
            super.setValue(2, (Variable)newValue);
        }

        public Integer32 getSnmp4jProxyType() {
            return (Integer32)super.getValue(3);
        }

        public void setSnmp4jProxyType(Integer32 newValue) {
            super.setValue(3, (Variable)newValue);
        }

        public OctetString getSnmp4jProxyTarget() {
            return (OctetString)super.getValue(4);
        }

        public void setSnmp4jProxyTarget(OctetString newValue) {
            super.setValue(4, (Variable)newValue);
        }

        public Integer32 getSnmp4jProxyStorageType() {
            return (Integer32)super.getValue(5);
        }

        public void setSnmp4jProxyStorageType(Integer32 newValue) {
            super.setValue(5, (Variable)newValue);
        }

        public Integer32 getSnmp4jProxyRowStatus() {
            return (Integer32)super.getValue(6);
        }

        public void setSnmp4jProxyRowStatus(Integer32 newValue) {
            super.setValue(6, (Variable)newValue);
        }

        public OID getSnmp4jProxyTargetSubtree() {
            return (OID)super.getValue(7);
        }

        public void setSnmp4jProxyTargetSubtree(OID newValue) {
            super.setValue(7, (Variable)newValue);
        }

        @Override
        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return this.getSnmp4jProxyContextEngineID();
                }
                case 1: {
                    return this.getSnmp4jProxyContextName();
                }
                case 2: {
                    return this.getSnmp4jProxySubtree();
                }
                case 3: {
                    return this.getSnmp4jProxyType();
                }
                case 4: {
                    return this.getSnmp4jProxyTarget();
                }
                case 5: {
                    return this.getSnmp4jProxyStorageType();
                }
                case 6: {
                    return this.getSnmp4jProxyRowStatus();
                }
                case 7: {
                    return this.getSnmp4jProxyTargetSubtree();
                }
            }
            return super.getValue(column);
        }

        @Override
        public void setValue(int column, Variable value) {
            switch (column) {
                case 0: {
                    this.setSnmp4jProxyContextEngineID((OctetString)value);
                    break;
                }
                case 1: {
                    this.setSnmp4jProxyContextName((OctetString)value);
                    break;
                }
                case 2: {
                    this.setSnmp4jProxySubtree((OID)value);
                    break;
                }
                case 3: {
                    this.setSnmp4jProxyType((Integer32)value);
                    break;
                }
                case 4: {
                    this.setSnmp4jProxyTarget((OctetString)value);
                    break;
                }
                case 5: {
                    this.setSnmp4jProxyStorageType((Integer32)value);
                    break;
                }
                case 6: {
                    this.setSnmp4jProxyRowStatus((Integer32)value);
                    break;
                }
                case 7: {
                    this.setSnmp4jProxyTargetSubtree((OID)value);
                    break;
                }
                default: {
                    super.setValue(column, value);
                }
            }
        }
    }

    static class Snmp4jProxyRowStatusValidator
    implements MOValueValidationListener {
        Snmp4jProxyRowStatusValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jProxyStorageTypeValidator
    implements MOValueValidationListener {
        Snmp4jProxyStorageTypeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jProxyTargetValidator
    implements MOValueValidationListener {
        Snmp4jProxyTargetValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class Snmp4jProxySubtreeValidator
    implements MOValueValidationListener {
        Snmp4jProxySubtreeValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class Snmp4jProxyContextNameValidator
    implements MOValueValidationListener {
        Snmp4jProxyContextNameValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class Snmp4jProxyContextEngineIDValidator
    implements MOValueValidationListener {
        Snmp4jProxyContextEngineIDValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 5 || os.length() > 32) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    public static final class Snmp4jProxyTypeEnum {
        public static final int invalid = 0;
        public static final int readAndWrite = 1;
        public static final int readOnly = 2;
        public static final int noProxy = 3;
    }
}

