/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.tc;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.smi.EnumerationConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class TruthValueTC
implements TextualConvention {
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    private EnumerationConstraint constraint = new EnumerationConstraint(new int[]{1, 2});

    public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
        MOColumn c;
        if (access.isAccessibleForWrite()) {
            c = new MOMutableColumn(columnID, 2, access, defaultValue);
            ((MOMutableColumn)c).addMOValueValidationListener(new ValueConstraintValidator(this.constraint));
        } else {
            c = new MOColumn(columnID, 2, access);
        }
        return c;
    }

    public MOScalar createScalar(OID oid, MOAccess access, Variable value) {
        MOScalar<Variable> scalar = new MOScalar<Variable>(oid, access, value == null ? this.createInitialValue() : value);
        if (this.constraint.validate(scalar.getValue()) != 0) {
            throw new IllegalArgumentException("Illegal TruthValue " + value);
        }
        scalar.addMOValueValidationListener(new ValueConstraintValidator(this.constraint));
        return scalar;
    }

    @Override
    public String getModuleName() {
        return "SNMPv2-TC";
    }

    @Override
    public String getName() {
        return "TruthValue";
    }

    public static Integer32 getValue(boolean b) {
        return b ? new Integer32(1) : new Integer32(2);
    }

    public Variable createInitialValue() {
        return new Integer32(2);
    }

    public static boolean getBooleanValue(Integer32 truthValue) {
        return 1 == truthValue.getValue();
    }
}

