/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Comparator;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class MOScopeComparator
implements Comparator<MOScope> {
    @Override
    public int compare(MOScope o1, MOScope o2) {
        if (o1 == o2) {
            return 0;
        }
        int result = 0;
        if (o2 instanceof MOQuery) {
            result = MOScopeComparator.compareQueryWithScope(o1, (MOQuery)o2);
        } else if (o1 instanceof MOQuery) {
            result = -MOScopeComparator.compareQueryWithScope(o2, (MOQuery)o1);
        } else if (o2 instanceof MOContextScope) {
            result = MOScopeComparator.compareContextScope(o1, (MOContextScope)o2);
        } else if (o1 instanceof MOContextScope) {
            result = -MOScopeComparator.compareContextScope(o2, (MOContextScope)o1);
        } else {
            result = o1.getLowerBound().compareTo((Variable)o2.getLowerBound());
            if (!(result != 0 || o1.isUpperIncluded() && o2.isLowerIncluded())) {
                return -1;
            }
        }
        return result;
    }

    private static int compareContextScope(MOScope scope, MOContextScope scope2) {
        int result = 0;
        if (scope.getUpperBound() == null) {
            result = 1;
            if (scope2.getUpperBound() == null && (result = scope.getLowerBound().compareTo((Variable)scope2.getLowerBound())) == 0) {
                result += scope.isLowerIncluded() ? -1 : 0;
                result += scope2.isLowerIncluded() ? 1 : 0;
            }
        } else {
            result = scope.getUpperBound().compareTo((Variable)scope2.getUpperBound());
            if (result == 0) {
                if (result == 0) {
                    result += scope.isUpperIncluded() ? -1 : 0;
                    result += scope2.isUpperIncluded() ? 1 : 0;
                }
                if (!(result != 0 || (result = scope.getUpperBound().compareTo((Variable)scope2.getLowerBound())) != 0 || scope.isUpperIncluded() && scope2.isLowerIncluded())) {
                    return -1;
                }
            }
        }
        if (result == 0 && scope instanceof MOContextScope) {
            OctetString c1 = ((MOContextScope)scope).getContext();
            OctetString c2 = scope2.getContext();
            if (c1 != null && c2 != null) {
                result = c1.compareTo((Variable)c2);
            }
        }
        return result;
    }

    private static int compareQueryWithScope(MOScope scope, MOQuery scope2) {
        int result = 0;
        if (scope.getUpperBound() == null) {
            return 1;
        }
        result = scope.getUpperBound().compareTo((Variable)scope2.getLowerBound());
        if (!(result != 0 || scope.isUpperIncluded() && scope2.isLowerIncluded())) {
            return -1;
        }
        if (result == 0 && scope instanceof MOContextScope) {
            OctetString c1 = ((MOContextScope)scope).getContext();
            OctetString c2 = scope2.getContext();
            if (c1 != null && c2 != null) {
                result = c1.compareTo((Variable)c2);
            }
        }
        return result;
    }

    public static boolean isQueryContextMatching(MOQuery a, MOScope b) {
        OctetString cb;
        OctetString ca = a.getContext();
        if (ca == null) {
            return true;
        }
        return !(b instanceof MOContextScope) || ca.equals((Object)(cb = ((MOContextScope)b).getContext()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MOScopeComparator) {
            return this == obj;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

