/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.BasicConfigurator;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.ext.StaticMOGroup;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class SnapshotAgent
extends BaseAgent {
    private static final LogAdapter logger;
    protected String address;
    protected File snapshot;
    protected List groups = new ArrayList();

    public SnapshotAgent(File bootCounterFile, File configFile, File snapshot) throws IOException {
        super(bootCounterFile, configFile, new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.agent.setWorkerPool((WorkerPool)ThreadPool.create((String)"RequestPool", (int)2));
        this.snapshot = snapshot;
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("cpublic"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
    }

    protected void addUsmUser(USM usm) {
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addGroup(3, new OctetString("v3notify"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 1, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.6.3.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void registerManagedObjects() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.snapshot);
            ObjectInputStream ois = new ObjectInputStream(fis);
            List l = (List)ois.readObject();
            ois.close();
            logger.info((Object)("Snapshot file '" + this.snapshot + "' contains " + l.size() + " objects."));
            OctetString ctx = new OctetString();
            TreeMap<OID, OID> roots = new TreeMap<OID, OID>();
            OID last = null;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                VariableBinding vb = (VariableBinding)it.next();
                if (last != null) {
                    for (int min = Math.min(vb.getOid().size(), last.size()); min > 0; --min) {
                        if (vb.getOid().leftMostCompare(min, last) != 0) continue;
                        OID root = new OID(last.getValue(), 0, min);
                        roots.put(root, root);
                        break;
                    }
                }
                last = vb.getOid();
            }
            logger.info((Object)("Identified the following sub-tree candidates: " + roots));
            TreeMap<OID, OID> rootsCopy = new TreeMap<OID, OID>();
            Iterator it2 = roots.keySet().iterator();
            while (it2.hasNext()) {
                OID k = (OID)it2.next();
                if (k.size() <= 1) continue;
                OID sk = new OID(k.getValue(), 0, k.size() - 1);
                while (sk.size() > 0 && roots.get(sk) == null) {
                    sk.trim(1);
                }
                if (sk.size() != 0) continue;
                rootsCopy.put(k, k);
            }
            logger.info((Object)("Identified the following sub-trees " + rootsCopy));
            it2 = rootsCopy.keySet().iterator();
            while (it2.hasNext()) {
                OID root = (OID)it2.next();
                ArrayList<VariableBinding> subtree = new ArrayList<VariableBinding>();
                Iterator vit = l.iterator();
                while (vit.hasNext()) {
                    VariableBinding vb = (VariableBinding)vit.next();
                    if (vb.getOid().size() < root.size() || vb.getOid().leftMostCompare(root.size(), root) != 0) continue;
                    subtree.add(vb);
                }
                StaticMOGroup group = new StaticMOGroup(root, subtree.toArray(new VariableBinding[subtree.size()]));
                DefaultMOContextScope scope = new DefaultMOContextScope(ctx, root, true, root.nextPeer(), false);
                ManagedObject mo = this.server.lookup(new DefaultMOQuery(scope, false));
                if (mo != null) {
                    logger.warn((Object)("Could not register snapshot subtree '" + root + "' with " + subtree + " because ManagedObject " + mo + " is already registered"));
                    continue;
                }
                this.groups.add(group);
                this.server.register(group, null);
                logger.info((Object)("Registered snapshot subtree '" + root + "' with " + subtree));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error while reading snapshot file '" + this.snapshot + "':" + ex.getMessage()), (Throwable)ex);
        }
    }

    protected void unregisterManagedObjects() {
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            ManagedObject mo = (ManagedObject)it.next();
            this.server.unregister(mo, null);
        }
    }

    protected void initTransportMappings() throws IOException {
        TransportMapping tm;
        this.transportMappings = new TransportMapping[1];
        Address addr = GenericAddress.parse((String)this.address);
        this.transportMappings[0] = tm = TransportMappings.getInstance().createTransportMapping(addr);
    }

    public static void main(String[] args) {
        File snapshot = new File(args[0]);
        BasicConfigurator.configure();
        String address = args.length > 1 ? args[1] : "0.0.0.0/161";
        try {
            SnapshotAgent testAgent1 = new SnapshotAgent(new File("SNMP4JSnapshotAgentBC.cfg"), new File("SNMP4JSnapshotAgentConfig.cfg"), snapshot);
            testAgent1.address = address;
            testAgent1.init();
            testAgent1.loadConfig(1);
            testAgent1.addShutdownHook();
            testAgent1.getServer().addContext(new OctetString("public"));
            testAgent1.finishInit();
            testAgent1.run();
            testAgent1.sendColdStartNotification();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex1) {
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        logger = LogFactory.getLogger((Class)SnapshotAgent.class);
    }
}

