/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.NotificationLogEvent;
import org.snmp4j.agent.mo.snmp.NotificationLogListener;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class NotificationOriginatorImpl
implements NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger((Class)NotificationOriginatorImpl.class);
    private Session session;
    private VACM vacm;
    private SnmpTargetMIB targetMIB;
    private SnmpNotificationMIB notificationMIB;
    private SnmpCommunityMIB communityMIB;
    private SysUpTime sysUpTime;
    private transient Vector notificationLogListeners;
    private long notificationEventID = 0L;
    private static OctetString EMPTY_CONTEXT_ENGINE_ID = new OctetString();

    public NotificationOriginatorImpl(Session session, VACM vacm, SysUpTime sysUpTime, SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        this.session = session;
        this.sysUpTime = sysUpTime;
        this.vacm = vacm;
        this.targetMIB = targetMIB;
        this.notificationMIB = notificationMIB;
    }

    public NotificationOriginatorImpl(Session session, VACM vacm, SysUpTime sysUpTime, SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB, SnmpCommunityMIB communityMIB) {
        this(session, vacm, sysUpTime, targetMIB, notificationMIB);
        this.communityMIB = communityMIB;
    }

    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, null, vbs);
    }

    private ResponseEvent sendNotification(MOTableRow addr, MOTableRow paramsRow, OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs, int type, long notificationEventID) {
        PDU pdu;
        CommunityTarget t;
        Address address;
        Integer32 mpModel = (Integer32)paramsRow.getValue(0);
        OctetString secName = (OctetString)paramsRow.getValue(2);
        Integer32 secLevel = (Integer32)paramsRow.getValue(3);
        OctetString community = secName;
        if (this.communityMIB != null) {
            community = this.communityMIB.getCommunity(secName, null, context);
        }
        if ((address = ((SnmpTargetMIB.SnmpTargetAddrEntryRow)addr).getAddress()) == null) {
            logger.debug((Object)("Invalid address in row " + addr + ", notification skipped"));
            return null;
        }
        switch (mpModel.getValue()) {
            case 0: {
                TransportMapping tm;
                t = new CommunityTarget(address, community);
                PDUv1 trap = new PDUv1();
                pdu = trap;
                if (sysUpTime != null) {
                    trap.setTimestamp(sysUpTime.getValue());
                } else {
                    trap.setTimestamp(this.sysUpTime.get().getValue());
                }
                int genericID = SnmpConstants.getGenericTrapID((OID)notificationID);
                if (genericID < 0) {
                    OID enterprise;
                    trap.setGenericTrap(6);
                    if (notificationID.size() > 2 && notificationID.get(notificationID.size() - 2) == 0) {
                        enterprise = new OID(notificationID.getValue(), 0, notificationID.size() - 2);
                        trap.setEnterprise(enterprise);
                    } else {
                        enterprise = new OID(notificationID.getValue(), 0, notificationID.size() - 1);
                        trap.setEnterprise(enterprise);
                    }
                    trap.setSpecificTrap(notificationID.last());
                } else {
                    trap.setGenericTrap(genericID);
                    trap.setEnterprise(new OID(new int[]{0, 0}));
                }
                if (!(this.session instanceof Snmp) || (tm = ((Snmp)this.session).getMessageDispatcher().getTransport(address)) == null || !(tm.getListenAddress() instanceof IpAddress)) break;
                InetAddress localAddress = ((IpAddress)tm.getListenAddress()).getInetAddress();
                trap.setAgentAddress(new IpAddress(localAddress));
                break;
            }
            case 1: {
                t = new CommunityTarget(address, community);
                pdu = new PDU();
                break;
            }
            default: {
                byte[] authEngineID = type == 2 ? new byte[]{} : this.targetMIB.getLocalEngineID();
                UserTarget ut = new UserTarget(address, secName, authEngineID, secLevel.getValue());
                t = ut;
                ScopedPDU scopedPdu = new ScopedPDU();
                scopedPdu.setContextName(context);
                this.setContextEngineID(scopedPdu, context, notificationID);
                pdu = scopedPdu;
            }
        }
        t.setVersion(mpModel.getValue());
        Integer32 timeout = (Integer32)addr.getValue(2);
        Integer32 retries = (Integer32)addr.getValue(3);
        t.setTimeout((long)(timeout.getValue() * 10));
        t.setRetries(retries.getValue());
        if (mpModel.getValue() != 0) {
            if (sysUpTime != null) {
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)sysUpTime));
            } else {
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)this.sysUpTime.get()));
            }
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)notificationID));
        }
        pdu.addAll(vbs);
        pdu.setType(type == 2 ? -90 : (mpModel.getValue() == 0 ? -92 : -89));
        try {
            OctetString localEngineID = new OctetString();
            OctetString contextEngineID = new OctetString();
            if (pdu instanceof ScopedPDU) {
                localEngineID.setValue(this.targetMIB.getLocalEngineID());
                contextEngineID = ((ScopedPDU)pdu).getContextEngineID();
            }
            ResponseEvent response = this.session.send(pdu, (Target)t);
            this.fireNotificationLogEvent(new NotificationLogEvent(this, localEngineID, (Target)t, contextEngineID, context, notificationID, sysUpTime, vbs, notificationEventID, true));
            logger.info((Object)("Sent notification with ID " + notificationEventID + " " + pdu + " to " + t));
            return response;
        }
        catch (IOException iox) {
            logger.error((Object)("Failed to send notification: " + iox.getMessage()), (Throwable)iox);
            return null;
        }
    }

    protected void setContextEngineID(ScopedPDU scopedPDU, OctetString context, OID notificationID) {
        scopedPDU.setContextEngineID(new OctetString(this.targetMIB.getLocalEngineID()));
    }

    private boolean isAccessGranted(MOTableRow addr, MOTableRow paramsRow, OctetString context, OID notificationID, VariableBinding[] vbs) {
        if (!this.notificationMIB.passesFilter(paramsRow.getIndex(), notificationID, vbs)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Notification " + notificationID + " did not pass filter " + paramsRow.getIndex()));
            }
            return false;
        }
        OctetString secName = (OctetString)paramsRow.getValue(2);
        Integer32 secLevel = (Integer32)paramsRow.getValue(3);
        Integer32 secModel = (Integer32)paramsRow.getValue(1);
        int status = this.vacm.isAccessAllowed(context, secName, secModel.getValue(), secLevel.getValue(), 0, notificationID);
        for (int i = 0; status == 0 && i < vbs.length; ++i) {
            status = this.vacm.isAccessAllowed(context, secName, secModel.getValue(), secLevel.getValue(), 0, vbs[i].getOid());
        }
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Notification " + notificationID + " reported with " + Arrays.asList(vbs) + " for context " + context));
        }
        if (context == null) {
            context = new OctetString();
        }
        LinkedList<ResponseEvent> responses = new LinkedList<ResponseEvent>();
        NotificationOriginatorImpl notificationOriginatorImpl = this;
        synchronized (notificationOriginatorImpl) {
            ++this.notificationEventID;
        }
        OctetString localEngineID = null;
        if (this.targetMIB != null && this.targetMIB.getLocalEngineID() != null) {
            localEngineID = new OctetString(this.targetMIB.getLocalEngineID());
        }
        this.fireNotificationLogEvent(new NotificationLogEvent(this, localEngineID, null, EMPTY_CONTEXT_ENGINE_ID, context, notificationID, sysUpTime, vbs, this.notificationEventID, false));
        Iterator it = this.notificationMIB.getNotifyTable().getModel().iterator();
        while (it.hasNext()) {
            MOTableRow notifyRow = (MOTableRow)it.next();
            OctetString tag = (OctetString)notifyRow.getValue(0);
            Integer32 type = (Integer32)notifyRow.getValue(1);
            Collection addresses = this.targetMIB.getTargetAddrRowsForTag(tag);
            RowStatus.ActiveRowsFilter aFilter = new RowStatus.ActiveRowsFilter(7);
            Iterator ait = addresses.iterator();
            while (ait.hasNext()) {
                MOTableRow addr = (MOTableRow)ait.next();
                if (!aFilter.passesFilter(addr)) continue;
                OctetString params = (OctetString)addr.getValue(5);
                MOTableRow paramsRow = this.targetMIB.getTargetParamsRow(params);
                if (RowStatus.isRowActive(paramsRow, 5)) {
                    if (this.isAccessGranted(addr, paramsRow, context, notificationID, vbs)) {
                        ResponseEvent response = this.sendNotification(addr, paramsRow, context, notificationID, sysUpTime, vbs, type.getValue(), this.notificationEventID);
                        responses.add(response);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Access denied by VACM for " + notificationID));
                    continue;
                }
                logger.warn((Object)"Found active target address but corrsponding params are not active");
            }
        }
        return responses.toArray(new ResponseEvent[0]);
    }

    public void setSession(Session snmpSession) {
        this.session = snmpSession;
    }

    public synchronized void addNotificationLogListener(NotificationLogListener l) {
        if (this.notificationLogListeners == null) {
            this.notificationLogListeners = new Vector(2);
        }
        this.notificationLogListeners.add(l);
    }

    public synchronized void removeNotificationLogListener(NotificationLogListener l) {
        if (this.notificationLogListeners != null) {
            this.notificationLogListeners.remove(l);
        }
    }

    protected void fireNotificationLogEvent(NotificationLogEvent event) {
        if (this.notificationLogListeners != null) {
            Vector listeners = this.notificationLogListeners;
            int count = this.notificationLogListeners.size();
            for (int i = 0; i < count; ++i) {
                ((NotificationLogListener)listeners.get(i)).notificationLogEvent(event);
            }
        }
    }
}

