/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.EventObject;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.StateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class CommandResponderEvent
extends EventObject {
    private static final long serialVersionUID = 1969372060103366769L;
    private int securityModel;
    private int securityLevel;
    private int maxSizeResponsePDU;
    private PduHandle pduHandle;
    private StateReference stateReference;
    private PDU pdu;
    private int messageProcessingModel;
    private byte[] securityName;
    private boolean processed;
    private Address peerAddress;
    private transient TransportMapping transportMapping;

    public CommandResponderEvent(MessageDispatcher messageDispatcher, TransportMapping transportMapping, Address sourceAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PduHandle pduHandle, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference) {
        super(messageDispatcher);
        this.setTransportMapping(transportMapping);
        this.setMessageProcessingModel(messageProcessingModel);
        this.setSecurityModel(securityModel);
        this.setSecurityName(securityName);
        this.setSecurityLevel(securityLevel);
        this.setPduHandle(pduHandle);
        this.setPDU(pdu);
        this.setMaxSizeResponsePDU(maxSizeResponseScopedPDU);
        this.setStateReference(stateReference);
        this.setPeerAddress(sourceAddress);
    }

    public CommandResponderEvent(Object source, CommandResponderEvent other) {
        super(source);
        this.setTransportMapping(other.transportMapping);
        this.setMessageProcessingModel(other.messageProcessingModel);
        this.setSecurityModel(other.securityModel);
        this.setSecurityName(other.securityName);
        this.setSecurityLevel(other.securityLevel);
        this.setPduHandle(other.pduHandle);
        this.setPDU(other.pdu);
        this.setMaxSizeResponsePDU(other.maxSizeResponsePDU);
        this.setStateReference(other.stateReference);
        this.setPeerAddress(other.getPeerAddress());
    }

    public MessageDispatcher getMessageDispatcher() {
        return (MessageDispatcher)super.getSource();
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setMaxSizeResponsePDU(int maxSizeResponsePDU) {
        this.maxSizeResponsePDU = maxSizeResponsePDU;
    }

    public int getMaxSizeResponsePDU() {
        return this.maxSizeResponsePDU;
    }

    public void setPduHandle(PduHandle pduHandle) {
        this.pduHandle = pduHandle;
    }

    public PduHandle getPduHandle() {
        return this.pduHandle;
    }

    public void setStateReference(StateReference stateReference) {
        this.stateReference = stateReference;
    }

    public StateReference getStateReference() {
        return this.stateReference;
    }

    public void setPDU(PDU pdu) {
        this.pdu = pdu;
    }

    public PDU getPDU() {
        return this.pdu;
    }

    public void setMessageProcessingModel(int messageProcessingModel) {
        this.messageProcessingModel = messageProcessingModel;
    }

    public int getMessageProcessingModel() {
        return this.messageProcessingModel;
    }

    public void setSecurityName(byte[] securityName) {
        this.securityName = securityName;
    }

    public byte[] getSecurityName() {
        return this.securityName;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public Address getPeerAddress() {
        return this.peerAddress;
    }

    public TransportMapping getTransportMapping() {
        return this.transportMapping;
    }

    public void setPeerAddress(Address peerAddress) {
        this.peerAddress = peerAddress;
    }

    protected void setTransportMapping(TransportMapping transportMapping) {
        this.transportMapping = transportMapping;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CommandResponderEvent[");
        buf.append("transportMapping=");
        buf.append(this.transportMapping);
        buf.append("peerAddress=");
        buf.append(this.peerAddress);
        buf.append(", processed=");
        buf.append(this.processed);
        buf.append(", pdu=[");
        buf.append(this.pdu);
        buf.append("], securityName=");
        buf.append(new OctetString(this.securityName));
        buf.append(", securityModel=");
        buf.append(this.securityModel);
        buf.append(", securityLevel=");
        buf.append(this.securityLevel);
        buf.append("]");
        return buf.toString();
    }
}

