/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import org.snmp4j.Target;
import org.snmp4j.smi.Address;

public abstract class AbstractTarget
implements Target {
    private Address address;
    private int version = 3;
    private int retries = 0;
    private long timeout = 1000L;
    private int maxSizeRequestPDU = 65535;

    protected AbstractTarget() {
    }

    protected AbstractTarget(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Number of retries < 0");
        }
        this.retries = retries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getMaxSizeRequestPDU() {
        return this.maxSizeRequestPDU;
    }

    public void setMaxSizeRequestPDU(int maxSizeRequestPDU) {
        if (maxSizeRequestPDU < 484) {
            throw new IllegalArgumentException("The minimum PDU length is: 484");
        }
        this.maxSizeRequestPDU = maxSizeRequestPDU;
    }

    protected String toStringAbstractTarget() {
        return "address=" + this.getAddress() + ", version=" + this.version + ", timeout=" + this.timeout + ", retries=" + this.retries;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toStringAbstractTarget() + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

