/*_############################################################################
  _## 
  _##  SNMP4J-AgentJMX 2 - EnumStringType.java  
  _## 
  _##  Copyright (C) 2005-2012  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/
package org.snmp4j.agent.mo.jmx.types;

import javax.management.*;
import java.lang.management.MemoryType;

public class EnumStringType extends TypedAttribute {

  private Enum[] enumValues;
  private Class<MemoryType> enumClass;
  private int offset = 0;

  public EnumStringType(String name, Class<MemoryType> enumClass, Enum[] enumValues) {
    super(name, Integer.class);
    this.enumClass = enumClass;
    this.enumValues = enumValues;
  }

  public Enum[] getEnumValues() {
    return enumValues;
  }

  public int getOffset() {
    return offset;
  }

  public Object transformFromNative(Object nativeValue, ObjectName objectName) {
    Enum<MemoryType> en;
    if (nativeValue instanceof Enum) {
      en = (Enum<MemoryType>)nativeValue;
    }
    else {
      en = Enum.valueOf(enumClass, nativeValue.toString());
    }
    return offset + en.ordinal();
  }

  public Object transformToNative(Object transformedValue,
                                  Object oldNativeValue, ObjectName objectName) {
    int i = ((Integer)transformedValue).intValue();
    return enumValues[i-offset];
  }

}
