/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.adapter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractPersistingAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFlowTelemetryAdapter
extends AbstractPersistingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SFlowTelemetryAdapter.class);
    private CollectionAgentFactory collectionAgentFactory;
    private InterfaceToNodeCache interfaceToNodeCache;

    public Stream<CollectionSetWithAgent> handleMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        InetAddress inetAddress;
        LOG.debug("Received {} telemetry messages", (Object)messageLog.getMessageList().size());
        LOG.trace("Parsing packet: {}", (Object)message);
        BsonDocument document = new RawBsonDocument(message.getByteArray()).getDocument((Object)"data");
        if (document == null) {
            return Stream.empty();
        }
        String address = (String)BsonUtils.first((Optional[])new Optional[]{BsonUtils.getString((BsonDocument)document, (String[])new String[]{"agent_address", "ipv6"}), BsonUtils.getString((BsonDocument)document, (String[])new String[]{"agent_address", "ipv4"})}).orElseThrow(() -> new IllegalStateException("Incomplete document"));
        try {
            inetAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to resolve agent address: {}", (Object)address);
            return Stream.empty();
        }
        Optional nodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), inetAddress);
        if (!nodeId.isPresent()) {
            LOG.warn("Unable to find node and interface for agent address: {}", (Object)address);
            return Stream.empty();
        }
        CollectionAgent agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString((Integer)nodeId.get()), inetAddress);
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        return document.getArray((Object)"samples").stream().map(BsonValue::asDocument).flatMap(sampleDocument -> {
            if ("0:2".equals(sampleDocument.get((Object)"format").asString().getValue()) || "0:4".equals(sampleDocument.get((Object)"format").asString().getValue())) {
                try {
                    CollectionSet collectionSet = builder.build(agent, (Object)sampleDocument.get((Object)"data").asDocument());
                    return Stream.of(new CollectionSetWithAgent(agent, collectionSet));
                }
                catch (ScriptException e) {
                    LOG.error("Error while running script: {}", (Object)e.getMessage());
                    return Stream.empty();
                }
            }
            return Stream.empty();
        });
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }
}

