/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.integration.api.xml.ConfigUtils;

@XmlRootElement(name="varbind")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Varbind
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> TEXTUAL_CONVENTIONS = Arrays.asList("PhysAddress", "MacAddress", "TruthValue", "TestAndIncr", "AutonomousType", "InstancePointer", "VariablePointer", "RowPointer", "RowStatus", "TimeStamp", "TimeInterval", "DateAndTime", "StorageType", "TDomain", "TAddress");
    @XmlAttribute(name="textual-convention", required=false)
    private String m_textualConvention;
    @XmlElement(name="vbnumber", required=true)
    private Integer m_vbnumber;
    @XmlElement(name="vbvalue", required=true)
    private List<String> m_values = new ArrayList<String>();

    public String getTextualConvention() {
        return this.m_textualConvention;
    }

    public void setTextualConvention(String textualConvention) {
        this.m_textualConvention = ConfigUtils.assertOnlyContains(textualConvention, TEXTUAL_CONVENTIONS, "textual-convention");
        if (this.m_textualConvention != null) {
            this.m_textualConvention = this.m_textualConvention.intern();
        }
    }

    public Integer getVbnumber() {
        return this.m_vbnumber;
    }

    public void setVbnumber(Integer vbnumber) {
        this.m_vbnumber = ConfigUtils.assertNotNull(vbnumber, "vbnumber");
    }

    public List<String> getVbvalues() {
        return this.m_values;
    }

    public void setVbvalues(List<String> values) {
        if (values == this.m_values) {
            return;
        }
        this.m_values.clear();
        if (values != null) {
            this.m_values.addAll(values);
        }
    }

    public void addVbvalue(String value) throws IndexOutOfBoundsException {
        this.m_values.add(value == null ? null : value.intern());
    }

    public boolean removeVbvalue(String value) {
        return this.m_values.remove(value);
    }

    public int hashCode() {
        return Objects.hash(this.m_textualConvention, this.m_vbnumber, this.m_values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Varbind) {
            Varbind that = (Varbind)obj;
            return Objects.equals(this.m_textualConvention, that.m_textualConvention) && Objects.equals(this.m_vbnumber, that.m_vbnumber) && Objects.equals(this.m_values, that.m_values);
        }
        return false;
    }
}

