/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.eventconf.MechanismType;
import org.opennms.integration.api.xml.schema.eventconf.StateType;

@XmlRootElement(name="forward")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Forward
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlValue
    private String m_content;
    @XmlAttribute(name="state", required=false)
    private StateType m_state;
    @XmlAttribute(name="mechanism", required=false)
    private MechanismType m_mechanism;

    public String getContent() {
        return this.m_content;
    }

    public MechanismType getMechanism() {
        return this.m_mechanism == null ? MechanismType.SNMPUDP : this.m_mechanism;
    }

    public StateType getState() {
        return this.m_state == null ? StateType.OFF : this.m_state;
    }

    public void setContent(String content) {
        this.m_content = ConfigUtils.normalizeAndInternString(content);
    }

    public void setMechanism(MechanismType mechanism) {
        this.m_mechanism = mechanism;
    }

    public void setState(StateType state) {
        this.m_state = state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_content, this.m_state, this.m_mechanism});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Forward) {
            Forward that = (Forward)obj;
            return Objects.equals(this.m_content, that.m_content) && Objects.equals((Object)this.m_state, (Object)that.m_state) && Objects.equals((Object)this.m_mechanism, (Object)that.m_mechanism);
        }
        return false;
    }
}

