/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radixreversed;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.util.PrettyPrintable;
import com.googlecode.concurrenttrees.radixreversed.ReversedRadixTree;
import java.io.Serializable;

public class ConcurrentReversedRadixTree<O>
implements ReversedRadixTree<O>,
PrettyPrintable,
Serializable {
    private final ConcurrentRadixTree<O> radixTree;

    public ConcurrentReversedRadixTree(NodeFactory nodeFactory) {
        this.radixTree = new ConcurrentReverseRadixTreeImpl(nodeFactory);
    }

    public ConcurrentReversedRadixTree(NodeFactory nodeFactory, boolean restrictConcurrency) {
        this.radixTree = new ConcurrentReverseRadixTreeImpl(nodeFactory, restrictConcurrency);
    }

    @Override
    public O getValueForExactKey(CharSequence key) {
        return this.radixTree.getValueForExactKey(CharSequences.reverse(key));
    }

    @Override
    public O put(CharSequence key, O value) {
        return this.radixTree.put(CharSequences.reverse(key), value);
    }

    @Override
    public O putIfAbsent(CharSequence key, O value) {
        return this.radixTree.putIfAbsent(CharSequences.reverse(key), value);
    }

    @Override
    public Iterable<CharSequence> getKeysEndingWith(CharSequence suffix) {
        return this.radixTree.getKeysStartingWith(CharSequences.reverse(suffix));
    }

    @Override
    public Iterable<O> getValuesForKeysEndingWith(CharSequence suffix) {
        return this.radixTree.getValuesForKeysStartingWith(CharSequences.reverse(suffix));
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysEndingWith(CharSequence suffix) {
        return this.radixTree.getKeyValuePairsForKeysStartingWith(CharSequences.reverse(suffix));
    }

    @Override
    public boolean remove(CharSequence key) {
        return this.radixTree.remove(CharSequences.reverse(key));
    }

    @Override
    public int size() {
        return this.radixTree.size();
    }

    @Override
    public Node getNode() {
        return this.radixTree.getNode();
    }

    class ConcurrentReverseRadixTreeImpl<O>
    extends ConcurrentRadixTree<O> {
        public ConcurrentReverseRadixTreeImpl(NodeFactory nodeFactory) {
            super(nodeFactory);
        }

        public ConcurrentReverseRadixTreeImpl(NodeFactory nodeFactory, boolean restrictConcurrency) {
            super(nodeFactory, restrictConcurrency);
        }

        @Override
        protected CharSequence transformKeyForResult(CharSequence rawKey) {
            return CharSequences.reverse(rawKey);
        }
    }
}

