/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.MetaData;

public final class ImmutableMetaData
implements MetaData {
    private final String context;
    private final String key;
    private final String value;

    private ImmutableMetaData(Builder builder) {
        this.context = builder.context;
        this.key = builder.key;
        this.value = builder.value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(MetaData metaData) {
        return new Builder(metaData);
    }

    public static MetaData immutableCopy(MetaData metaData) {
        if (metaData == null || metaData instanceof ImmutableMetaData) {
            return metaData;
        }
        return ImmutableMetaData.newBuilderFrom(metaData).build();
    }

    public String getContext() {
        return this.context;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMetaData that = (ImmutableMetaData)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.key, this.value);
    }

    public String toString() {
        return "ImmutableMetaData{context='" + this.context + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static final class Builder {
        private String context;
        private String key;
        private String value;

        private Builder() {
        }

        private Builder(MetaData metaData) {
            this.context = metaData.getContext();
            this.key = metaData.getKey();
            this.value = metaData.getValue();
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ImmutableMetaData build() {
            return new ImmutableMetaData(this);
        }
    }
}

