/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.immutables.ImmutableEventParameter;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableInMemoryEvent
implements InMemoryEvent {
    private final String uei;
    private final String source;
    private final Severity severity;
    private final Integer nodeId;
    private final List<EventParameter> parameters;

    private ImmutableInMemoryEvent(Builder builder) {
        this.uei = builder.uei;
        this.source = builder.source;
        this.severity = builder.severity;
        this.nodeId = builder.nodeId;
        this.parameters = ImmutableCollections.with(ImmutableEventParameter::immutableCopy).newList(builder.parameters);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(InMemoryEvent inMemoryEvent) {
        return new Builder(inMemoryEvent);
    }

    public static InMemoryEvent immutableCopy(InMemoryEvent inMemoryEvent) {
        if (inMemoryEvent == null || inMemoryEvent instanceof ImmutableInMemoryEvent) {
            return inMemoryEvent;
        }
        return ImmutableInMemoryEvent.newBuilderFrom(inMemoryEvent).build();
    }

    public String getUei() {
        return this.uei;
    }

    public String getSource() {
        return this.source;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public List<EventParameter> getParameters() {
        return this.parameters;
    }

    public Optional<String> getParameterValue(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).findFirst().map(EventParameter::getValue);
    }

    public List<EventParameter> getParametersByName(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableInMemoryEvent that = (ImmutableInMemoryEvent)o;
        return Objects.equals(this.uei, that.uei) && Objects.equals(this.source, that.source) && this.severity == that.severity && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.uei, this.source, this.severity, this.nodeId, this.parameters);
    }

    public String toString() {
        return "ImmutableInMemoryEvent{uei='" + this.uei + '\'' + ", source='" + this.source + '\'' + ", severity=" + this.severity + ", nodeId=" + this.nodeId + ", parameters=" + this.parameters + '}';
    }

    public static final class Builder {
        private String uei;
        private String source;
        private Severity severity;
        private Integer nodeId;
        private List<EventParameter> parameters;

        private Builder() {
        }

        private Builder(InMemoryEvent inMemoryEvent) {
            this.uei = inMemoryEvent.getUei();
            this.source = inMemoryEvent.getSource();
            this.severity = inMemoryEvent.getSeverity();
            this.nodeId = inMemoryEvent.getNodeId();
            this.parameters = MutableCollections.copyListFromNullable(inMemoryEvent.getParameters(), LinkedList::new);
        }

        public Builder setUei(String uei) {
            this.uei = Objects.requireNonNull(uei);
            return this;
        }

        public Builder setSource(String source) {
            this.source = Objects.requireNonNull(source);
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setNodeId(Integer nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setParameters(List<EventParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addParameter(EventParameter parameter) {
            if (this.parameters == null) {
                this.parameters = new LinkedList<EventParameter>();
            }
            this.parameters.add(parameter);
            return this;
        }

        public ImmutableInMemoryEvent build() {
            Objects.requireNonNull(this.uei);
            Objects.requireNonNull(this.source);
            return new ImmutableInMemoryEvent(this);
        }
    }
}

