/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.EventParameter;

public final class ImmutableEventParameter
implements EventParameter {
    private final String name;
    private final String value;

    private ImmutableEventParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static ImmutableEventParameter newInstance(String name, String value) {
        return new ImmutableEventParameter(Objects.requireNonNull(name), value);
    }

    public static EventParameter immutableCopy(EventParameter eventParameter) {
        if (eventParameter == null || eventParameter instanceof ImmutableEventParameter) {
            return eventParameter;
        }
        return ImmutableEventParameter.newInstance(eventParameter.getName(), eventParameter.getValue());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(EventParameter eventParameter) {
        return new Builder(eventParameter);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEventParameter that = (ImmutableEventParameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "ImmutableEventParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static final class Builder {
        private String name;
        private String value;

        private Builder() {
        }

        private Builder(EventParameter eventParameter) {
            this.name = eventParameter.getName();
            this.value = eventParameter.getValue();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ImmutableEventParameter build() {
            return ImmutableEventParameter.newInstance(this.name, this.value);
        }
    }
}

