/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.registry.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.netmgt.telemetry.api.TelemetryBeanFactory;
import org.opennms.netmgt.telemetry.config.api.TelemetryBeanDefinition;
import org.opennms.netmgt.telemetry.protocols.registry.api.TelemetryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class TelemetryServiceRegistryImpl<F extends TelemetryBeanFactory, BD extends TelemetryBeanDefinition, T>
implements TelemetryServiceRegistry<BD, T>,
ServiceLookup<String, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryServiceRegistryImpl.class);
    private final Map<String, ServiceFactoryRegistration> m_serviceFactoryByClassName = new HashMap<String, ServiceFactoryRegistration>();
    private final ServiceLookup<String, Void> delegate;
    @Autowired
    private ApplicationContext applicationContext;

    public TelemetryServiceRegistryImpl(Supplier<ServiceLoader<F>> staticServiceSupplier) {
        this(staticServiceSupplier, ServiceLookupBuilder.GRACE_PERIOD_MS, ServiceLookupBuilder.WAIT_PERIOD_MS, ServiceLookupBuilder.LOOKUP_DELAY_MS);
    }

    public TelemetryServiceRegistryImpl(Supplier<ServiceLoader<F>> staticServiceSupplier, long gracePeriodMs, long waitPeriodMs, long lookupDelayMs) {
        this.delegate = new ServiceLookupBuilder((ServiceLookup)new ServiceLookup<String, Void>(){

            public <T> T lookup(String criteria, Void filter) {
                return (T)TelemetryServiceRegistryImpl.this.m_serviceFactoryByClassName.get(criteria);
            }
        }).blocking(gracePeriodMs, lookupDelayMs, waitPeriodMs).build();
        if (staticServiceSupplier != null) {
            for (TelemetryBeanFactory serviceFactory : staticServiceSupplier.get()) {
                String className = serviceFactory.getBeanClass().getCanonicalName();
                this.m_serviceFactoryByClassName.put(className, new ServiceFactoryRegistration<TelemetryBeanFactory>(serviceFactory, true));
            }
        }
    }

    public synchronized void onBind(F serviceFactory, Map properties) {
        LOG.debug("Bind called with {}: {}", serviceFactory, (Object)properties);
        if (serviceFactory != null) {
            Class clazz = serviceFactory.getBeanClass();
            if (clazz == null) {
                LOG.warn("Unable to determine the class for ServiceFactory: {}, with properties: {}. The service will not be registered.", serviceFactory, (Object)properties);
                return;
            }
            String className = clazz.getCanonicalName();
            this.m_serviceFactoryByClassName.put(className, new ServiceFactoryRegistration<F>(serviceFactory, false));
        }
    }

    public synchronized void onUnbind(F serviceFactory, Map properties) {
        LOG.debug("Unbind called with {}: {}", serviceFactory, (Object)properties);
        if (serviceFactory != null) {
            Class clazz = serviceFactory.getBeanClass();
            if (clazz == null) {
                LOG.warn("Unable to determine the class name for ServiceFactory: {}, with properties: {}. The service will not be unregistered.", serviceFactory, (Object)properties);
                return;
            }
            String className = clazz.getCanonicalName();
            this.m_serviceFactoryByClassName.remove(className);
        }
    }

    @Override
    public T getService(BD beanDefinition) {
        ServiceFactoryRegistration registration = (ServiceFactoryRegistration)this.delegate.lookup((Object)beanDefinition.getClassName(), null);
        if (registration != null) {
            Object service = registration.getServiceFactory().createBean(beanDefinition);
            if (registration.shouldAutowire()) {
                AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
                beanFactory.autowireBean(service);
                beanFactory.initializeBean(service, "service");
            }
            return (T)service;
        }
        return null;
    }

    public <T> T lookup(String criteria, Void filter) {
        return (T)this.delegate.lookup((Object)criteria, (Object)filter);
    }

    private static class ServiceFactoryRegistration<T extends TelemetryBeanFactory> {
        private final T factory;
        private final boolean autowire;

        public ServiceFactoryRegistration(T factory, boolean autowire) {
            this.factory = (TelemetryBeanFactory)Objects.requireNonNull(factory);
            this.autowire = autowire;
        }

        public T getServiceFactory() {
            return this.factory;
        }

        public boolean shouldAutowire() {
            return this.autowire;
        }
    }
}

