/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsTopologyDaoInMemoryImpl
implements OnmsTopologyDao {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsTopologyDaoInMemoryImpl.class);
    private final Map<OnmsTopologyProtocol, OnmsTopologyUpdater> m_updatersMap = new HashMap<OnmsTopologyProtocol, OnmsTopologyUpdater>();
    private final Set<OnmsTopologyConsumer> m_consumers = new HashSet<OnmsTopologyConsumer>();

    @Override
    public OnmsTopology getTopology(String protocolSupported) {
        OnmsTopologyProtocol protocol = OnmsTopologyProtocol.create(protocolSupported);
        if (this.m_updatersMap.containsKey(protocol)) {
            return this.m_updatersMap.get(protocol).getTopology();
        }
        throw new IllegalArgumentException(String.format("%s protocol not supported", protocolSupported));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<OnmsTopologyProtocol, OnmsTopology> getTopologies() {
        HashMap<OnmsTopologyProtocol, OnmsTopology> topologies = new HashMap<OnmsTopologyProtocol, OnmsTopology>();
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            this.m_updatersMap.forEach((key, value) -> topologies.put((OnmsTopologyProtocol)key, value.getTopology()));
        }
        return topologies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            LOG.debug("Consumer subscribed {}", (Object)consumer);
            this.m_consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(OnmsTopologyConsumer consumer) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            LOG.debug("Consumer unsubscribed {}", (Object)consumer);
            this.m_consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBind(OnmsTopologyConsumer consumer, Map<String, String> properties) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            LOG.debug("Consumer {} bind with properties {}", (Object)consumer, properties);
            this.m_consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnbind(OnmsTopologyConsumer consumer, Map<String, String> properties) {
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            LOG.debug("Consumer {} unbind with properties {}", (Object)consumer, properties);
            this.m_consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(OnmsTopologyUpdater updater) {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            if (this.m_updatersMap.containsKey(updater.getProtocol())) {
                throw new IllegalArgumentException("Protocol already registered " + updater.getProtocol());
            }
            this.m_updatersMap.put(updater.getProtocol(), updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(OnmsTopologyUpdater updater) {
        Map<OnmsTopologyProtocol, OnmsTopologyUpdater> map = this.m_updatersMap;
        synchronized (map) {
            OnmsTopologyUpdater subscribed = this.m_updatersMap.get(updater.getProtocol());
            if (subscribed == null || subscribed != updater) {
                throw new IllegalArgumentException("updater is not registered " + updater.getProtocol());
            }
            this.m_updatersMap.remove(updater.getProtocol());
        }
    }

    @Override
    public Set<OnmsTopologyProtocol> getSupportedProtocols() {
        return this.m_updatersMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(OnmsTopologyUpdater updater, OnmsTopologyMessage message) {
        OnmsTopologyProtocol protocol = updater.getProtocol();
        if (!this.m_updatersMap.containsKey(protocol)) {
            throw new IllegalArgumentException(String.format("cannot update message with id: %s. Protocol %s not supported for message status %s", new Object[]{message.getMessagebody().getId(), protocol, message.getMessagestatus()}));
        }
        if (this.m_updatersMap.get(protocol) != updater) {
            throw new IllegalArgumentException(String.format("cannot update message with id: %s, protocol: %s and message status: %s. Updater not registered", new Object[]{message.getMessagebody().getId(), protocol, message.getMessagestatus()}));
        }
        Set<OnmsTopologyConsumer> set = this.m_consumers;
        synchronized (set) {
            this.m_consumers.stream().filter(consumer -> {
                if (consumer.getProtocols() == null || consumer.getProtocols().isEmpty()) {
                    return false;
                }
                return consumer.getProtocols().contains(OnmsTopologyProtocol.allProtocols()) || consumer.getProtocols().contains(protocol);
            }).forEach(consumer -> consumer.consume(message));
        }
    }
}

