/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.CdpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.CdpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class CdpTopologyServiceImpl
extends TopologyServiceImpl
implements CdpTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(CdpTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_cdpElementDao.deleteByNodeId(nodeid);
        this.m_cdpLinkDao.deleteByNodeId(nodeid);
        this.m_cdpElementDao.flush();
        this.m_cdpLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        CdpElement element = this.m_cdpElementDao.findByNodeId(nodeId);
        if (element != null && element.getCdpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_cdpElementDao.delete(element);
            this.m_cdpElementDao.flush();
        }
        this.m_cdpLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_cdpLinkDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, CdpElement element) {
        if (element == null) {
            return;
        }
        CdpElement dbelement = this.m_cdpElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_cdpElementDao.saveOrUpdate(dbelement);
            this.m_cdpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
        this.m_cdpElementDao.saveOrUpdate(element);
        this.m_cdpElementDao.flush();
        this.updatesAvailable();
    }

    @Override
    public void store(int nodeId, CdpLink link) {
        if (link == null) {
            return;
        }
        this.saveCdpLink(nodeId, link);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveCdpLink(final int nodeId, final CdpLink saveMe) {
        new UpsertTemplate<CdpLink, CdpLinkDao>(this.m_transactionManager, this.m_cdpLinkDao){

            @Override
            protected CdpLink query() {
                return ((CdpLinkDao)this.m_dao).get(nodeId, saveMe.getCdpCacheIfIndex(), saveMe.getCdpCacheDeviceIndex());
            }

            @Override
            protected CdpLink doUpdate(CdpLink dbCdpLink) {
                dbCdpLink.merge(saveMe);
                ((CdpLinkDao)this.m_dao).update(dbCdpLink);
                ((CdpLinkDao)this.m_dao).flush();
                return dbCdpLink;
            }

            @Override
            protected CdpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setCdpLinkLastPollTime(saveMe.getCdpLinkCreateTime());
                ((CdpLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((CdpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public List<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> match() {
        List<CdpElementTopologyEntity> cdpElements = this.getTopologyEntityCache().getCdpElementTopologyEntities();
        List<CdpLinkTopologyEntity> allLinks = this.getTopologyEntityCache().getCdpLinkTopologyEntities();
        HashMap<Integer, CdpElementTopologyEntity> cdpelementmap = new HashMap<Integer, CdpElementTopologyEntity>();
        for (CdpElementTopologyEntity cdpElementTopologyEntity : cdpElements) {
            cdpelementmap.put(cdpElementTopologyEntity.getNodeId(), cdpElementTopologyEntity);
        }
        HashMap<CompositeKey, CdpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, CdpLinkTopologyEntity>();
        for (CdpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getCdpCacheDevicePort(), targetLink.getCdpInterfaceName(), ((CdpElementTopologyEntity)cdpelementmap.get(targetLink.getNodeId())).getCdpGlobalDeviceId(), targetLink.getCdpCacheDeviceId());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> results = new ArrayList<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>>();
        for (CdpLinkTopologyEntity sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: source: {} ", (Object)sourceLink);
            }
            CdpElementTopologyEntity sourceCdpElement = (CdpElementTopologyEntity)cdpelementmap.get(sourceLink.getNodeId());
            CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)targetLinkMap.get(new CompositeKey(sourceLink.getCdpInterfaceName(), sourceLink.getCdpCacheDevicePort(), sourceLink.getCdpCacheDeviceId(), sourceCdpElement.getCdpGlobalDeviceId()));
            if (targetLink == null) {
                LOG.debug("getCdpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: cdp: {}, target: {} ", (Object)sourceLink.getCdpCacheDevicePort(), (Object)targetLink);
            }
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
            results.add(TopologyConnection.of(sourceLink, targetLink));
        }
        return results;
    }

    @Override
    public List<CdpElementTopologyEntity> findAllCdpElements() {
        return this.getTopologyEntityCache().getCdpElementTopologyEntities();
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }
}

