/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class MacPort
implements Topology {
    private Integer m_nodeId;
    private Integer m_macPortIfIndex;
    private String m_macPortName;
    private Map<String, Set<InetAddress>> m_macPortMap = new HashMap<String, Set<InetAddress>>();

    public static MacPort create(IpNetToMedia media) {
        HashSet<InetAddress> ips = new HashSet<InetAddress>();
        ips.add(media.getNetAddress());
        MacPort port = new MacPort();
        port.setNodeId(media.getNodeId());
        port.setIfIndex(media.getIfIndex());
        port.setMacPortName(media.getPort());
        port.getMacPortMap().put(media.getPhysAddress(), ips);
        return port;
    }

    public static MacPort merge(IpNetToMedia media, MacPort port) {
        if (!port.getMacPortMap().containsKey(media.getPhysAddress())) {
            HashSet ips = new HashSet();
            port.getMacPortMap().put(media.getPhysAddress(), ips);
        }
        port.getMacPortMap().get(media.getPhysAddress()).add(media.getNetAddress());
        return port;
    }

    private MacPort() {
    }

    public String getPortMacInfo() {
        StringBuffer strbfr = new StringBuffer();
        this.m_macPortMap.keySet().stream().forEach(mac -> {
            strbfr.append("ip:[");
            this.m_macPortMap.get(mac).stream().forEach(ip -> {
                strbfr.append(InetAddressUtils.str((InetAddress)ip));
                strbfr.append(" ");
            });
            strbfr.append("], mac:[");
            strbfr.append((String)mac);
            strbfr.append("]");
        });
        return strbfr.toString();
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("nodeid:[");
        strbfr.append(this.m_nodeId);
        strbfr.append("], port name:[");
        strbfr.append(this.m_macPortName);
        strbfr.append("], ifindex:[");
        strbfr.append(this.m_macPortIfIndex);
        strbfr.append("], macPortMap:[");
        strbfr.append(this.m_macPortMap);
        strbfr.append("]");
        return strbfr.toString();
    }

    public Integer getIfIndex() {
        return this.m_macPortIfIndex;
    }

    public void setIfIndex(Integer macPortIfIndex) {
        this.m_macPortIfIndex = macPortIfIndex;
    }

    public String getMacPortName() {
        return this.m_macPortName;
    }

    public void setMacPortName(String macPortName) {
        this.m_macPortName = macPortName;
    }

    public Map<String, Set<InetAddress>> getMacPortMap() {
        return this.m_macPortMap;
    }

    public void setMacPortMap(Map<String, Set<InetAddress>> macPortMap) {
        this.m_macPortMap = macPortMap;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_macPortIfIndex == null ? 0 : this.m_macPortIfIndex.hashCode());
        result = 31 * result + (this.m_macPortMap == null ? 0 : this.m_macPortMap.hashCode());
        result = 31 * result + (this.m_macPortName == null ? 0 : this.m_macPortName.hashCode());
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacPort other = (MacPort)obj;
        if (this.m_macPortIfIndex == null ? other.m_macPortIfIndex != null : !this.m_macPortIfIndex.equals(other.m_macPortIfIndex)) {
            return false;
        }
        if (this.m_macPortMap == null ? other.m_macPortMap != null : !this.m_macPortMap.equals(other.m_macPortMap)) {
            return false;
        }
        if (this.m_macPortName == null ? other.m_macPortName != null : !this.m_macPortName.equals(other.m_macPortName)) {
            return false;
        }
        return !(this.m_nodeId == null ? other.m_nodeId != null : !this.m_nodeId.equals(other.m_nodeId));
    }
}

