/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.opennms.protocols.http.HttpUrlConnection;
import org.opennms.protocols.http.HttpUrlHandler;
import org.opennms.protocols.http.HttpsUrlHandler;
import org.opennms.protocols.sftp.Sftp3gppUrlHandler;
import org.opennms.protocols.sftp.SftpUrlConnection;
import org.opennms.protocols.sftp.SftpUrlHandler;
import org.opennms.protocols.xml.config.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UrlFactory.class);

    private UrlFactory() {
    }

    public static URL getUrl(String urlStr, Request request) throws MalformedURLException {
        URL url = null;
        String protocol = null;
        try {
            protocol = urlStr.substring(0, urlStr.indexOf("://")).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
        url = "sftp".equals(protocol) ? new URL(null, urlStr, new SftpUrlHandler()) : ("sftp.3gpp".equals(protocol) ? new URL(null, urlStr, new Sftp3gppUrlHandler()) : ("http".equals(protocol) ? new URL(null, urlStr, new HttpUrlHandler(request)) : ("https".equals(protocol) ? new URL(null, urlStr, new HttpsUrlHandler(request)) : new URL(urlStr))));
        return url;
    }

    public static void disconnect(URLConnection connection) {
        try {
            if (connection == null) {
                return;
            }
            if (connection instanceof SftpUrlConnection) {
                ((SftpUrlConnection)connection).disconnect();
            }
            if (connection instanceof HttpUrlConnection) {
                ((HttpUrlConnection)connection).disconnect();
            }
        }
        catch (Exception e) {
            LOG.error("Can't close open connection.", (Throwable)e);
        }
    }
}

