/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.flows;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.LinkedList;
import java.util.Objects;
import org.opennms.netmgt.flows.api.Converter;
import org.opennms.netmgt.flows.api.FlowException;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowAdapter<P>
implements Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlowAdapter.class);
    private final FlowRepository flowRepository;
    private final Converter<P> converter;
    private final Timer logParsingTimer;
    private final Histogram packetsPerLogHistogram;

    public AbstractFlowAdapter(MetricRegistry metricRegistry, FlowRepository flowRepository, Converter<P> converter) {
        this.flowRepository = Objects.requireNonNull(flowRepository);
        this.converter = Objects.requireNonNull(converter);
        this.logParsingTimer = metricRegistry.timer("logParsing");
        this.packetsPerLogHistogram = metricRegistry.histogram("packetsPerLog");
    }

    public void setConfig(AdapterDefinition protocol) {
    }

    public void handleMessageLog(TelemetryMessageLog messageLog) {
        LOG.debug("Received {} telemetry messages", (Object)messageLog.getMessageList().size());
        LinkedList<P> flowPackets = new LinkedList<P>();
        LinkedList flows = new LinkedList();
        try (Timer.Context ctx = this.logParsingTimer.time();){
            for (TelemetryMessageLogEntry eachMessage : messageLog.getMessageList()) {
                LOG.trace("Parsing packet: {}", (Object)eachMessage);
                P flowPacket = this.parse(eachMessage);
                if (flowPacket == null) continue;
                flowPackets.add(flowPacket);
                flows.addAll(this.converter.convert(flowPacket));
            }
            this.packetsPerLogHistogram.update(flowPackets.size());
        }
        try {
            LOG.debug("Persisting {} packets, {} flows.", (Object)flowPackets.size(), (Object)flows.size());
            FlowSource source = new FlowSource(messageLog.getLocation(), messageLog.getSourceAddress());
            this.flowRepository.persist(flows, source);
        }
        catch (FlowException ex) {
            LOG.error("Failed to persist one or more packets: {}", (Object)ex.getMessage());
        }
        LOG.debug("Completed processing {} telemetry messages.", (Object)messageLog.getMessageList().size());
    }

    protected abstract P parse(TelemetryMessageLogEntry var1);

    public void destroy() {
    }
}

