/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.activemq.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.JassCredentialCallbackHandler;
import org.apache.activemq.security.AbstractAuthenticationBroker;
import org.apache.activemq.security.JaasAuthenticationBroker;
import org.apache.activemq.security.SecurityContext;
import org.opennms.netmgt.activemq.auth.JaasSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSJaasAuthenticationBroker
extends AbstractAuthenticationBroker {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSJaasAuthenticationBroker.class);
    private static final String JAAS_CONTEXT_NAME = "opennms";
    private static final Pattern EXTRACT_IP_ADDRESS_PATTERN = Pattern.compile("tcp://([0-9\\.:]+):([0-9]+)");
    private boolean isJaasContextAvailable = false;
    private final Set<InetAddress> trustedHosts;
    private final String usernameForTrustedHosts;
    private final Set<Principal> principalsForTrustedHosts;

    public OpenNMSJaasAuthenticationBroker(Broker next, Set<InetAddress> trustedHosts, String usernameForTrustedHosts, Set<Principal> principalsForTrustedHosts) {
        super(next);
        this.trustedHosts = Objects.requireNonNull(trustedHosts);
        this.usernameForTrustedHosts = Objects.requireNonNull(usernameForTrustedHosts);
        this.principalsForTrustedHosts = Objects.requireNonNull(principalsForTrustedHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            this.authenticateBasedOnRemoteAddress(context, info);
            if (context.getSecurityContext() == null) {
                OpenNMSJaasAuthenticationBroker openNMSJaasAuthenticationBroker = this;
                synchronized (openNMSJaasAuthenticationBroker) {
                    if (!this.isJaasContextAvailable) {
                        this.isJaasContextAvailable = this.waitForJaasContext();
                    }
                }
                this.authenticateUsingJaas(context, info);
            }
        }
        super.addConnection(context, info);
    }

    protected static InetAddress getAddressFromConnectionString(String remoteAddress) {
        Matcher m = EXTRACT_IP_ADDRESS_PATTERN.matcher(remoteAddress);
        if (m.matches()) {
            try {
                return InetAddress.getByName(m.group(1));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    private void authenticateBasedOnRemoteAddress(ConnectionContext context, ConnectionInfo info) {
        boolean grant = false;
        String connectionString = context.getConnection().getRemoteAddress();
        if (connectionString.startsWith("vm://")) {
            grant = true;
        } else {
            InetAddress remoteAddress = OpenNMSJaasAuthenticationBroker.getAddressFromConnectionString(connectionString);
            if (remoteAddress == null) {
                LOG.warn("Unable to determine remote address from connection string: {}", (Object)connectionString);
            } else if (this.trustedHosts.contains(remoteAddress)) {
                grant = true;
            }
        }
        if (!grant) {
            LOG.info("Connection from '{}' is NOT trusted.", (Object)connectionString);
            return;
        }
        LOG.info("Connection from '{}' is trusted.", (Object)connectionString);
        SecurityContext securityContext = new SecurityContext(this.usernameForTrustedHosts){

            public Set<Principal> getPrincipals() {
                return OpenNMSJaasAuthenticationBroker.this.principalsForTrustedHosts;
            }
        };
        context.setSecurityContext(securityContext);
        this.securityContexts.add(securityContext);
    }

    private boolean waitForJaasContext() {
        long sleepMs = TimeUnit.SECONDS.toMillis(2L);
        long maxSleepMs = TimeUnit.MINUTES.toMillis(3L);
        for (long k = 0L; k < maxSleepMs; k += sleepMs) {
            try {
                new LoginContext(JAAS_CONTEXT_NAME);
                return true;
            }
            catch (LoginException loginException) {
                try {
                    Thread.sleep(sleepMs);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticateUsingJaas(ConnectionContext context, ConnectionInfo info) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
        try {
            SecurityContext s = this.authenticate(info.getUserName(), info.getPassword(), null);
            context.setSecurityContext(s);
            this.securityContexts.add(s);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public SecurityContext authenticate(String username, String password, X509Certificate[] certificates) throws SecurityException {
        JaasSecurityContext result = null;
        JassCredentialCallbackHandler callback = new JassCredentialCallbackHandler(username, password);
        try {
            LoginContext lc = new LoginContext(JAAS_CONTEXT_NAME, (CallbackHandler)callback);
            lc.login();
            Subject subject = lc.getSubject();
            result = new JaasSecurityContext(username, subject);
        }
        catch (Exception ex) {
            throw new SecurityException("User name [" + username + "] or password is invalid.", ex);
        }
        return result;
    }
}

