/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.health.shell.NamedMetricSet;
import org.osgi.framework.BundleContext;

@Command(scope="health", name="metrics-list", description="List the available metric sets.")
@Service
public class MetricsListCommand
implements Action {
    @Reference
    private BundleContext bundleContext;

    public Object execute() {
        List<NamedMetricSet> metricSets = NamedMetricSet.getNamedMetricSetsInContext(this.bundleContext);
        if (metricSets.size() < 1) {
            System.out.println("(No metric sets are currently available.)");
            return null;
        }
        int maxNameLength = metricSets.stream().mapToInt(m -> m.getName().length()).max().getAsInt();
        String format = String.format("%%-%ds\t%%s\n", maxNameLength);
        System.out.printf(format, "Name", "Description");
        for (NamedMetricSet namedMetricSet : metricSets) {
            System.out.printf(format, namedMetricSet.getName(), namedMetricSet.hasDescription() ? namedMetricSet.getDescription() : "(No description)");
        }
        System.out.println();
        return null;
    }
}

