/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.aws.sqs;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.ipc.common.aws.sqs.AmazonSQSQueueAttributes;

public class AmazonSQSQueueConfig {
    public static final ImmutableMap<String, String> DEFAULT_QUEUE_ATTRIBUTES = new ImmutableMap.Builder().put((Object)AmazonSQSQueueAttributes.DelaySeconds.toString(), (Object)"0").put((Object)AmazonSQSQueueAttributes.MaximumMessageSize.toString(), (Object)"262144").put((Object)AmazonSQSQueueAttributes.MessageRetentionPeriod.toString(), (Object)"1209600").put((Object)AmazonSQSQueueAttributes.ReceiveMessageWaitTimeSeconds.toString(), (Object)"10").put((Object)AmazonSQSQueueAttributes.VisibilityTimeout.toString(), (Object)"30").put((Object)AmazonSQSQueueAttributes.FifoQueue.toString(), (Object)"false").put((Object)AmazonSQSQueueAttributes.ContentBasedDeduplication.toString(), (Object)"false").build();
    private final Map<String, String> attributes;

    public AmazonSQSQueueConfig(Map<String, String> sqsConfig) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (AmazonSQSQueueAttributes attr : AmazonSQSQueueAttributes.values()) {
            String val = sqsConfig.getOrDefault(attr.toString(), (String)DEFAULT_QUEUE_ATTRIBUTES.get((Object)attr.toString()));
            if (val == null) continue;
            attributes.put(attr.toString(), val);
        }
        if (!Boolean.parseBoolean((String)attributes.get(AmazonSQSQueueAttributes.FifoQueue.toString()))) {
            attributes.remove(AmazonSQSQueueAttributes.FifoQueue.toString());
            attributes.remove(AmazonSQSQueueAttributes.ContentBasedDeduplication.toString());
        }
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isFifoEnabled() {
        return Boolean.parseBoolean(this.attributes.get(AmazonSQSQueueAttributes.FifoQueue.toString()));
    }

    public boolean isFifoContentDedupEnabled() {
        return Boolean.parseBoolean(this.attributes.get(AmazonSQSQueueAttributes.ContentBasedDeduplication.toString()));
    }

    public String toString() {
        return "AmazonSQSQueueConfig{attributes=" + this.attributes + '}';
    }
}

