/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import org.opennms.netmgt.snmp.SnmpValue;

public abstract class AbstractSnmpValue
implements SnmpValue {
    public static boolean allBytesDisplayable(byte[] bytes) {
        if (AbstractSnmpValue.allBytesUTF_8(bytes)) {
            return true;
        }
        return AbstractSnmpValue.allBytesISO_8859_1(bytes);
    }

    public static boolean allBytesUTF_8(byte[] bytes) {
        int i = 0;
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            i = 3;
        }
        int j = bytes.length;
        while (i < j) {
            byte octet = bytes[i];
            if ((octet & 0x80) == 0) {
                if (octet == 0) {
                    if (i != j - 1) {
                        return false;
                    }
                } else {
                    if (octet < 32 && octet != 9 && octet != 10 && octet != 13) {
                        return false;
                    }
                    if (octet == 127) {
                        return false;
                    }
                }
            } else {
                int end;
                if ((octet & 0xE0) == 192) {
                    end = i + 1;
                } else if ((octet & 0xF0) == 224) {
                    end = i + 2;
                } else if ((octet & 0xF8) == 240) {
                    end = i + 3;
                } else {
                    return false;
                }
                while (i < end) {
                    if (((octet = bytes[++i]) & 0xC0) == 128) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean allBytesISO_8859_1(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 0) {
                if (i == bytes.length - 1) continue;
                return false;
            }
            if (b >= 0 && b < 32 && b != 9 && b != 10 && b != 13) {
                return false;
            }
            if (b == 127) {
                return false;
            }
            if (b < -128 || b >= -96) continue;
            return false;
        }
        return true;
    }
}

