/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.measurements.api.FilterParam;

@XmlRootElement(name="parameter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterParamMetaData {
    @XmlAttribute(name="key", required=true)
    private String key;
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlAttribute(name="displayName", required=true)
    private String displayName;
    @XmlAttribute(name="description", required=true)
    private String description;
    @XmlAttribute(name="default")
    private String defaultValue;
    @XmlAttribute(name="required", required=true)
    private boolean required = false;

    public FilterParamMetaData() {
    }

    public FilterParamMetaData(Field field, FilterParam filterParam) {
        Preconditions.checkNotNull((Object)field, (Object)"field argument");
        Preconditions.checkNotNull((Object)filterParam, (Object)"filterParam argument");
        this.key = filterParam.key();
        this.type = field.getType().getSimpleName().toLowerCase();
        this.displayName = filterParam.displayName();
        this.description = filterParam.description();
        this.defaultValue = filterParam.value();
        this.required = filterParam.required();
        if (this.required) {
            this.defaultValue = null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterParamMetaData other = (FilterParamMetaData)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.displayName, (Object)other.displayName) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.defaultValue, (Object)other.defaultValue) && Objects.equal((Object)this.required, (Object)other.required);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.type, this.displayName, this.description, this.defaultValue, this.required});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Key", (Object)this.key).add("Type", (Object)this.type).add("Display Name", (Object)this.displayName).add("Description", (Object)this.description).add("Default", (Object)this.defaultValue).add("Required", this.required).toString();
    }
}

