/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringWriter;
import java.util.Objects;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.elastic.FlowDocument;

public class ConversationKeyUtils {
    private static final Gson gson = new GsonBuilder().create();

    public static ConversationKey fromJsonString(String json) {
        Object[] array = (Object[])gson.fromJson(json, Object[].class);
        if (array.length != 5) {
            throw new IllegalArgumentException("Invalid conversation key string: " + json);
        }
        return new ConversationKey((String)array[0], Integer.valueOf(((Number)array[1]).intValue()), (String)array[2], (String)array[3], (String)array[4]);
    }

    public static String getConvoKeyAsJsonString(FlowDocument document) {
        if (document.getLocation() != null && document.getProtocol() != null && document.getSrcAddr() != null && document.getDstAddr() != null) {
            StringWriter writer = new StringWriter();
            writer.write("[");
            writer.write(gson.toJson((Object)document.getLocation()));
            writer.write(",");
            writer.write(Integer.toString(document.getProtocol()));
            writer.write(",\"");
            if (Objects.compare(document.getSrcAddr(), document.getDstAddr(), String::compareTo) < 0) {
                writer.write(document.getSrcAddr());
                writer.write("\",\"");
                writer.write(document.getDstAddr());
            } else {
                writer.write(document.getDstAddr());
                writer.write("\",\"");
                writer.write(document.getSrcAddr());
            }
            writer.write("\",");
            if (document.getApplication() != null) {
                writer.write("\"");
                writer.write(document.getApplication());
                writer.write("\"");
            } else {
                writer.write("null");
            }
            writer.write("]");
            return writer.toString();
        }
        return null;
    }
}

