/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.distributed.core.shell;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.RestClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractPingCommand
implements Action {
    @Reference
    private BundleContext bundleContext;
    @Reference
    public RestClient restClient;
    @Reference
    private Identity identity;
    @Option(name="-j", description="Maximum number of milliseconds to wait before failing when attempting to establish a JMS session.")
    public long jmsTimeoutMillis = 20000L;

    public Object execute() throws Exception {
        ConnectionFactory connectionFactory;
        System.out.println("WARNING: The ping command is deprecated, please use health:check instead\n");
        System.out.println("Connecting to ReST...");
        this.restClient.ping();
        System.out.println("OK");
        ServiceReference connectionFactoryRef = this.bundleContext.getServiceReference(ConnectionFactory.class);
        if (connectionFactoryRef != null && (connectionFactory = (ConnectionFactory)this.bundleContext.getService(connectionFactoryRef)) != null) {
            System.out.println("Connecting to Broker...");
            this.testJmsConnectivity(connectionFactory, this.jmsTimeoutMillis);
            System.out.println("OK");
        }
        return null;
    }

    private void testJmsConnectivity(final ConnectionFactory connectionFactory, long maxDurationMillis) throws InterruptedException, ExecutionException, TimeoutException {
        final AtomicReference throwableRef = new AtomicReference();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection jmsConnection = null;
                    try {
                        jmsConnection = connectionFactory.createConnection();
                        jmsConnection.createSession(false, 1).close();
                    }
                    finally {
                        if (jmsConnection != null) {
                            try {
                                jmsConnection.close();
                            }
                            catch (JMSException ex) {
                                System.out.println("Failed to close the JMS connection: " + ex.getMessage());
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    throwableRef.set(t);
                }
            }
        });
        t.setName(String.format("%s:ping", this.identity.getType().toLowerCase()));
        t.start();
        t.join(maxDurationMillis);
        if (t.isAlive()) {
            t.interrupt();
            throw new TimeoutException(String.format("Failed to create a JMS session within %d milliseconds.", maxDurationMillis));
        }
        if (throwableRef.get() != null) {
            throw new ExecutionException("Failed to create a JMS session.", (Throwable)throwableRef.get());
        }
    }
}

