/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.util.EnumerationIterator;

public class Log4jLogAdapter
implements LogAdapter,
Comparable {
    private final Logger logger;
    private static final String FQCN = Log4jLogAdapter.class.getName();

    public Log4jLogAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void debug(Serializable message) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)message, null);
    }

    @Override
    public void error(Serializable message) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)message, null);
    }

    @Override
    public void error(CharSequence message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)message, throwable);
    }

    @Override
    public void info(CharSequence message) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(Serializable message) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)message, null);
    }

    @Override
    public void fatal(Object message) {
        this.logger.log(FQCN, (Priority)Level.FATAL, message, null);
    }

    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.FATAL, (Object)message, throwable);
    }

    @Override
    public void setLogLevel(LogLevel level) {
        Level l;
        switch (level.getLevel()) {
            case 1: {
                l = Level.OFF;
                break;
            }
            case 2: {
                l = Level.ALL;
                break;
            }
            case 3: {
                l = Level.DEBUG;
                break;
            }
            case 4: {
                l = Level.DEBUG;
                break;
            }
            case 5: {
                l = Level.INFO;
                break;
            }
            case 6: {
                l = Level.WARN;
                break;
            }
            case 7: {
                l = Level.ERROR;
                break;
            }
            case 8: {
                l = Level.FATAL;
                break;
            }
            default: {
                l = null;
            }
        }
        this.logger.setLevel(l);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel getLogLevel() {
        Level l = this.logger.getLevel();
        return this.toLogLevel(l);
    }

    private LogLevel toLogLevel(Level l) {
        if (l == null) {
            return LogLevel.NONE;
        }
        switch (l.toInt()) {
            case 0x7FFFFFFF: {
                return LogLevel.OFF;
            }
            case -2147483648: {
                return LogLevel.ALL;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
            case 50000: {
                return LogLevel.FATAL;
            }
        }
        return LogLevel.DEBUG;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Log4jLogAdapter)o).getName());
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        Level l = this.logger.getEffectiveLevel();
        return this.toLogLevel(l);
    }

    @Override
    public Iterator<Appender> getLogHandler() {
        return new EnumerationIterator<Appender>(this.logger.getAllAppenders());
    }
}

