/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.opennms.core.rpc.api.RpcTarget;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;

public class RpcTargetHelper {
    protected static final String LOCATION_KEY = "location";
    protected static final String SYSTEM_ID_KEY = "system-id";
    protected static final String USE_FOREIGN_ID_AS_SYSTEM_ID_KEY = "use-foreign-id-as-system-id";
    @Autowired(required=false)
    private NodeDao nodeDao;

    public RpcTargetBuilder target() {
        return new RpcTargetBuilder().withNodeDao(this.nodeDao);
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public static class RpcTargetBuilder {
        private String location;
        private String systemId;
        private Integer nodeId;
        private NodeDao nodeDao;
        private Map<String, Object> serviceAttributes;
        private Function<String, String> locationOverride;

        public RpcTargetBuilder withNodeId(Integer nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        protected RpcTargetBuilder withNodeDao(NodeDao nodeDao) {
            this.nodeDao = nodeDao;
            return this;
        }

        public RpcTargetBuilder withLocation(String location) {
            this.location = location;
            return this;
        }

        public RpcTargetBuilder withSystemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public RpcTargetBuilder withServiceAttributes(Map<String, Object> attributes) {
            this.serviceAttributes = attributes;
            return this;
        }

        public RpcTargetBuilder withLocationOverride(Function<String, String> locationOverride) {
            this.locationOverride = locationOverride;
            return this;
        }

        public RpcTarget build() {
            OnmsNode node;
            String locationFromOverride;
            String targetLocation = this.location;
            String locationFromAttributes = this.getStringAttribute(RpcTargetHelper.LOCATION_KEY);
            if (locationFromAttributes != null) {
                targetLocation = locationFromAttributes;
            }
            if (this.locationOverride != null && (locationFromOverride = this.locationOverride.apply(targetLocation)) != null) {
                targetLocation = locationFromOverride;
            }
            String targetSystemId = this.systemId;
            String systemIdFromAttributes = this.getStringAttribute(RpcTargetHelper.SYSTEM_ID_KEY);
            if (systemIdFromAttributes != null) {
                targetSystemId = systemIdFromAttributes;
            }
            if (Boolean.TRUE.toString().equalsIgnoreCase(this.getStringAttribute(RpcTargetHelper.USE_FOREIGN_ID_AS_SYSTEM_ID_KEY)) && this.nodeId != null && this.nodeDao != null && (node = (OnmsNode)this.nodeDao.get((Serializable)this.nodeId)) != null && node.getForeignId() != null) {
                targetSystemId = node.getForeignId();
            }
            return new RpcTarget(targetLocation, targetSystemId);
        }

        private String getStringAttribute(String key) {
            if (this.serviceAttributes == null) {
                return null;
            }
            Object value = this.serviceAttributes.get(key);
            if (value != null && value instanceof String) {
                return (String)value;
            }
            return null;
        }
    }
}

