/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;

public class TimingClassificationEngine
implements ClassificationEngine {
    private final ClassificationEngine delegate;
    private final Timer classifyTimer;
    private final Timer reloadTimer;

    public TimingClassificationEngine(MetricRegistry metricRegistry, ClassificationEngine delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.classifyTimer = metricRegistry.timer("classify");
        this.reloadTimer = metricRegistry.timer("reload");
    }

    public String classify(ClassificationRequest classificationRequest) {
        try (Timer.Context ctx = this.classifyTimer.time();){
            String string = this.delegate.classify(classificationRequest);
            return string;
        }
    }

    public void reload() {
        try (Timer.Context ctx = this.reloadTimer.time();){
            this.delegate.reload();
        }
    }
}

