/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.csv.CsvImportResult;
import org.opennms.netmgt.flows.classification.csv.CsvService;
import org.opennms.netmgt.flows.classification.exception.CSVImportException;
import org.opennms.netmgt.flows.classification.exception.ClassificationException;
import org.opennms.netmgt.flows.classification.exception.InvalidRuleException;
import org.opennms.netmgt.flows.classification.internal.csv.CsvServiceImpl;
import org.opennms.netmgt.flows.classification.internal.validation.GroupValidator;
import org.opennms.netmgt.flows.classification.internal.validation.RuleValidator;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationGroupDao;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationRuleDao;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RulePriorityComparator;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultClassificationService
implements ClassificationService {
    private final ClassificationRuleDao classificationRuleDao;
    private final ClassificationGroupDao classificationGroupDao;
    private final ClassificationEngine classificationEngine;
    private final RuleValidator ruleValidator;
    private final CsvService csvService;
    private final GroupValidator groupValidator;
    private final TransactionOperations transactionTemplate;

    public DefaultClassificationService(ClassificationRuleDao classificationRuleDao, ClassificationGroupDao classificationGroupDao, ClassificationEngine classificationEngine, FilterService filterService, TransactionOperations transactionOperations) {
        this.classificationRuleDao = Objects.requireNonNull(classificationRuleDao);
        this.classificationGroupDao = Objects.requireNonNull(classificationGroupDao);
        this.classificationEngine = Objects.requireNonNull(classificationEngine);
        this.transactionTemplate = Objects.requireNonNull(transactionOperations);
        this.ruleValidator = new RuleValidator(filterService);
        this.groupValidator = new GroupValidator(classificationRuleDao);
        this.csvService = new CsvServiceImpl(this.ruleValidator);
    }

    public List<Rule> findMatchingRules(Criteria criteria) {
        return this.classificationRuleDao.findMatching(criteria);
    }

    public int countMatchingRules(Criteria criteria) {
        return this.classificationRuleDao.countMatching(criteria);
    }

    public Rule getRule(int ruleId) {
        Rule rule = (Rule)this.classificationRuleDao.get((Serializable)Integer.valueOf(ruleId));
        if (rule == null) {
            throw new NoSuchElementException();
        }
        return rule;
    }

    public Integer saveRule(Rule rule) throws InvalidRuleException {
        return (Integer)this.runInTransaction(status -> {
            Group group = this.classificationGroupDao.findByName("user-defined");
            this.ruleValidator.validate(rule);
            this.groupValidator.validate(group, rule);
            group.addRule(rule);
            Integer ruleId = (Integer)this.classificationRuleDao.save((Object)rule);
            this.updateRulePositionsAndReloadEngine(group);
            return ruleId;
        });
    }

    public void importRules(InputStream inputStream, boolean hasHeader, boolean deleteExistingRules) throws CSVImportException {
        this.runInTransaction(status -> {
            CsvImportResult result = this.csvService.parseCSV(inputStream, hasHeader);
            if (!result.isSuccess()) {
                throw new CSVImportException(result);
            }
            Group group = this.classificationGroupDao.findByName("user-defined");
            if (deleteExistingRules) {
                for (Rule eachRule : group.getRules()) {
                    eachRule.setGroup(null);
                }
                group.getRules().clear();
            }
            List rules = result.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                Rule rule = (Rule)rules.get(i);
                try {
                    this.groupValidator.validate(group, rule);
                    group.addRule(rule);
                    continue;
                }
                catch (ClassificationException ex) {
                    result.markError((long)i, ex.getError());
                }
            }
            if (!result.isSuccess()) {
                throw new CSVImportException(result);
            }
            this.updateRulePositionsAndReloadEngine(group);
            this.classificationGroupDao.saveOrUpdate((Object)group);
            return null;
        });
    }

    public String exportRules(int groupId) {
        Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
        if (group == null) {
            throw new NoSuchElementException();
        }
        String csvContent = this.csvService.createCSV(group.getRules());
        return csvContent;
    }

    public void deleteRules(int groupId) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(Rule.class).alias("group", "group");
        criteriaBuilder.eq("group.id", (Object)groupId);
        this.runInTransaction(status -> {
            Criteria criteria = criteriaBuilder.toCriteria();
            this.classificationRuleDao.findMatching(criteria).forEach(r -> this.classificationRuleDao.delete(r));
            this.classificationEngine.reload();
            return null;
        });
    }

    public void deleteRule(int ruleId) {
        this.runInTransaction(status -> {
            Rule rule = (Rule)this.classificationRuleDao.get((Serializable)Integer.valueOf(ruleId));
            if (rule == null) {
                throw new NoSuchElementException();
            }
            return this.runInTransaction(transactionStatus -> {
                Group group = rule.getGroup();
                group.removeRule(rule);
                this.classificationRuleDao.delete((Object)rule);
                this.updateRulePositionsAndReloadEngine(group);
                return null;
            });
        });
    }

    public void updateRule(Rule rule) {
        if (rule.getId() == null) {
            throw new NoSuchElementException();
        }
        this.runInTransaction(status -> {
            this.ruleValidator.validate(rule);
            this.groupValidator.validate(rule.getGroup(), rule);
            this.classificationRuleDao.saveOrUpdate((Object)rule);
            this.updateRulePositionsAndReloadEngine(rule.getGroup());
            return null;
        });
    }

    public String classify(ClassificationRequest classificationRequest) {
        String classification = this.classificationEngine.classify(classificationRequest);
        return classification;
    }

    public List<Group> findMatchingGroups(Criteria criteria) {
        return this.classificationGroupDao.findMatching(criteria);
    }

    public int countMatchingGroups(Criteria criteria) {
        return this.classificationGroupDao.countMatching(criteria);
    }

    public Group getGroup(int groupId) {
        Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
        if (group == null) {
            throw new NoSuchElementException();
        }
        return group;
    }

    public void deleteGroup(int groupId) {
        this.runInTransaction(status -> {
            Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
            if (group == null) {
                throw new NoSuchElementException();
            }
            this.classificationGroupDao.delete((Object)group);
            this.classificationEngine.reload();
            return null;
        });
    }

    public void updateGroup(Group group) {
        if (group.getId() == null) {
            throw new NoSuchElementException();
        }
        this.runInTransaction(status -> {
            this.classificationGroupDao.saveOrUpdate((Object)group);
            this.updateRulePositionsAndReloadEngine(group);
            return null;
        });
    }

    private <T> T runInTransaction(TransactionCallback<T> callback) {
        return (T)this.transactionTemplate.execute(callback);
    }

    private void updateRulePositionsAndReloadEngine(Group group) {
        List rules = group.getRules();
        Collections.sort(rules, new RulePriorityComparator());
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = (Rule)rules.get(i);
            rule.setPosition(i);
            this.classificationRuleDao.saveOrUpdate((Object)rule);
        }
        this.classificationEngine.reload();
    }
}

