/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MatchResult {
    public static final MatchResult FALSE = MatchResult.of(false);
    public static final MatchResult TRUE = MatchResult.of(true);
    private final boolean matched;
    private final Map<String, String> eventParameters;

    private MatchResult(boolean matched) {
        this.matched = matched;
        this.eventParameters = Collections.emptyMap();
    }

    private MatchResult(boolean matched, Map<String, String> eventParameters) {
        this.matched = matched;
        this.eventParameters = Collections.unmodifiableMap(new LinkedHashMap<String, String>(eventParameters));
    }

    public static MatchResult of(boolean matches) {
        return new MatchResult(matches);
    }

    public static MatchResult of(boolean matches, Map<String, String> eventParameters) {
        return new MatchResult(matches, eventParameters);
    }

    public MatchResult and(MatchResult other) {
        if (!this.matched) {
            return this;
        }
        if (!other.matched) {
            return other;
        }
        HashMap<String, String> allEventParameters = new HashMap<String, String>();
        allEventParameters.putAll(this.eventParameters);
        allEventParameters.putAll(other.eventParameters);
        return MatchResult.of(true, allEventParameters);
    }

    public boolean matched() {
        return this.matched;
    }

    public Map<String, String> getEventParameters() {
        return this.eventParameters;
    }
}

