/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wmi.Rrd;
import org.opennms.netmgt.config.wmi.Wpm;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"m_rrd", "m_wpms"})
@XmlRootElement(name="wmi-collection")
@ValidateUsing(value="wmi-datacollection.xsd")
public class WmiCollection
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="rrd", required=true)
    protected Rrd m_rrd;
    @XmlElementWrapper(name="wpms", required=true)
    @XmlElement(name="wpm", required=true)
    protected List<Wpm> m_wpms = new ArrayList<Wpm>();
    @XmlAttribute(name="name", required=true)
    protected String m_name;

    public Rrd getRrd() {
        return this.m_rrd;
    }

    public void setRrd(Rrd rrd) {
        this.m_rrd = ConfigUtils.assertNotNull(rrd, "rrd");
    }

    public List<Wpm> getWpms() {
        return this.m_wpms;
    }

    public void setWpms(List<Wpm> wpms) {
        this.m_wpms = (List)ConfigUtils.assertMinimumSize((Collection)ConfigUtils.assertNotNull(wpms, "wpms"), 1L, "wpms");
    }

    public void addWpm(Wpm wpm) {
        this.m_wpms.add(wpm);
    }

    public boolean removeWpm(Wpm wpm) {
        return this.m_wpms.remove(wpm);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WmiCollection)) {
            return false;
        }
        WmiCollection that = (WmiCollection)obj;
        return Objects.equals(this.m_rrd, that.m_rrd) && Objects.equals(this.m_wpms, that.m_wpms) && Objects.equals(this.m_name, that.m_name);
    }

    public int hashCode() {
        return Objects.hash(this.m_rrd, this.m_wpms, this.m_name);
    }
}

