/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reporting;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.reporting.DefaultTime;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="date-parm")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="reporting.xsd")
public class DateParm
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="display-name", required=true)
    private String m_displayName;
    @XmlAttribute(name="use-absolute-date")
    private Boolean m_useAbsoluteDate;
    @XmlElement(name="default-interval", required=true)
    private String m_defaultInterval;
    @XmlElement(name="default-count", required=true)
    private Integer m_defaultCount;
    @XmlElement(name="default-time")
    private DefaultTime m_defaultTime;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = ConfigUtils.assertNotEmpty(displayName, "display-name");
    }

    public Optional<Boolean> getUseAbsoluteDate() {
        return Optional.ofNullable(this.m_useAbsoluteDate);
    }

    public void setUseAbsoluteDate(Boolean useAbsoluteDate) {
        this.m_useAbsoluteDate = useAbsoluteDate;
    }

    public String getDefaultInterval() {
        return this.m_defaultInterval;
    }

    public void setDefaultInterval(String defaultInterval) {
        this.m_defaultInterval = ConfigUtils.assertNotEmpty(defaultInterval, "default-interval");
    }

    public Integer getDefaultCount() {
        return this.m_defaultCount;
    }

    public void setDefaultCount(Integer defaultCount) {
        this.m_defaultCount = ConfigUtils.assertNotNull(defaultCount, "default-count");
    }

    public Optional<DefaultTime> getDefaultTime() {
        return Optional.ofNullable(this.m_defaultTime);
    }

    public void setDefaultTime(DefaultTime defaultTime) {
        this.m_defaultTime = defaultTime;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_displayName, this.m_useAbsoluteDate, this.m_defaultInterval, this.m_defaultCount, this.m_defaultTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DateParm) {
            DateParm that = (DateParm)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_displayName, that.m_displayName) && Objects.equals(this.m_useAbsoluteDate, that.m_useAbsoluteDate) && Objects.equals(this.m_defaultInterval, that.m_defaultInterval) && Objects.equals(this.m_defaultCount, that.m_defaultCount) && Objects.equals(this.m_defaultTime, that.m_defaultTime);
        }
        return false;
    }
}

