/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="auto-acknowledge")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notifd-configuration.xsd")
public class AutoAcknowledge
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_RESOLUTION_PREFIX = "RESOLVED: ";
    @XmlAttribute(name="resolution-prefix")
    private String m_resolutionPrefix;
    @XmlAttribute(name="uei", required=true)
    private String m_uei;
    @XmlAttribute(name="acknowledge", required=true)
    private String m_acknowledge;
    @XmlAttribute(name="notify")
    private Boolean m_notify;
    @XmlElement(name="match", required=true)
    private List<String> m_matches = new ArrayList<String>();

    public String getResolutionPrefix() {
        return this.m_resolutionPrefix != null ? this.m_resolutionPrefix : DEFAULT_RESOLUTION_PREFIX;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this.m_resolutionPrefix = ConfigUtils.normalizeString(resolutionPrefix);
    }

    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String uei) {
        this.m_uei = ConfigUtils.assertNotEmpty(uei, "uei");
    }

    public String getAcknowledge() {
        return this.m_acknowledge;
    }

    public void setAcknowledge(String acknowledge) {
        this.m_acknowledge = ConfigUtils.assertNotEmpty(acknowledge, "acknowledge");
    }

    public Boolean getNotify() {
        return this.m_notify != null ? this.m_notify : Boolean.TRUE;
    }

    public void setNotify(Boolean notify) {
        this.m_notify = notify;
    }

    public List<String> getMatches() {
        return this.m_matches;
    }

    public void setMatches(List<String> matches) {
        if (matches == this.m_matches) {
            return;
        }
        this.m_matches.clear();
        if (matches != null) {
            this.m_matches.addAll(matches);
        }
    }

    public void addMatch(String match) {
        this.m_matches.add(match);
    }

    public int hashCode() {
        return Objects.hash(this.m_resolutionPrefix, this.m_uei, this.m_acknowledge, this.m_notify, this.m_matches);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoAcknowledge) {
            AutoAcknowledge that = (AutoAcknowledge)obj;
            return Objects.equals(this.m_resolutionPrefix, that.m_resolutionPrefix) && Objects.equals(this.m_uei, that.m_uei) && Objects.equals(this.m_acknowledge, that.m_acknowledge) && Objects.equals(this.m_notify, that.m_notify) && Objects.equals(this.m_matches, that.m_matches);
        }
        return false;
    }
}

